/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter;

import cn.hutool.core.collection.CollectionUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.thread.NamedThreadFactory;
import com.bxm.thirdparty.platform.adapter.AbstractThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.facade.notify.BaseNotifyResponse;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.interceptor.IInterceptorExecutor;
import com.bxm.thirdparty.platform.interceptor.IThirdPartyInterceptor;
import com.bxm.thirdparty.platform.queue.QueueService;
import com.bxm.thirdparty.platform.queue.bo.QueueBO;
import com.bxm.thirdparty.platform.queue.bo.RequestBodyBO;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ThirdPartyPlatformManage {
    private static final Logger log = LoggerFactory.getLogger(ThirdPartyPlatformManage.class);
    private final ThreadPoolExecutor taskExecutor;
    @Resource
    private IInterceptorExecutor iInterceptorExecutor;
    @Resource
    private QueueService queueService;
    private Map<String, AbstractThirdPartyPlatformAction> platformActionHashMap = new HashMap<String, AbstractThirdPartyPlatformAction>();

    public ThirdPartyPlatformManage(List<AbstractThirdPartyPlatformAction> iThirdPartyPlatformActions) {
        for (AbstractThirdPartyPlatformAction iThirdPartyPlatformAction : iThirdPartyPlatformActions) {
            this.platformActionHashMap.put(this.buildKey(iThirdPartyPlatformAction), iThirdPartyPlatformAction);
        }
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(200);
        int corePoolSize = Runtime.getRuntime().availableProcessors() * 2;
        String poolName = "exec-third-platform";
        this.taskExecutor = new ThreadPoolExecutor(corePoolSize, corePoolSize * 2, 60L, TimeUnit.SECONDS, queue, (ThreadFactory)new NamedThreadFactory(poolName, true), (r, executor) -> log.error("\u7b2c\u4e09\u65b9\u5b50\u7ebf\u7a0b\u5904\u7406\u5931\u8d25"));
    }

    private String buildKey(PlatformContext context) {
        return context.getRequest().getClass().getSimpleName();
    }

    private String buildKey(AbstractThirdPartyPlatformAction partyPlatformAction) {
        return partyPlatformAction.support().getSimpleName();
    }

    public <T extends BaseRequest, O> Message execCore(PlatformContext<T, O> context) {
        AbstractThirdPartyPlatformAction iThirdPartyPlatformAction = this.platformActionHashMap.get(this.buildKey(context));
        if (Objects.isNull(iThirdPartyPlatformAction)) {
            return Message.build((boolean)false).setMessage("\u5e73\u53f0\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (CollectionUtil.isNotEmpty(iThirdPartyPlatformAction.interceptors())) {
            HashSet<Class<IThirdPartyInterceptor>> set = new HashSet<Class<IThirdPartyInterceptor>>(iThirdPartyPlatformAction.interceptors());
            for (Class clazz : set) {
                Message accept = this.iInterceptorExecutor.accept(clazz, (BaseRequest)context.getRequest());
                if (accept.isSuccess()) continue;
                log.warn("\u4e1a\u52a1\u8bf7\u6c42\u88ab\u62e6\u622a\uff0cparam:{},\u62e6\u622a\u5668:{}", context, (Object)clazz.getSimpleName());
                return iThirdPartyPlatformAction.fallback((BaseRequest)context.getRequest());
            }
        }
        if (context.getMock().booleanValue()) {
            BaseNotifyResponse baseNotifyResponse = new BaseNotifyResponse();
            baseNotifyResponse.setSuccess(Boolean.valueOf(true));
            this.addQueueNotify(context, JSON.toJSONString((Object)baseNotifyResponse));
            return iThirdPartyPlatformAction.mockResult(context);
        }
        Message response = Message.build((boolean)false);
        if (context.getSync().booleanValue()) {
            response = this.retryRequestPost(iThirdPartyPlatformAction, context, 0);
        } else {
            this.taskExecutor.execute(() -> this.retryRequestPost(iThirdPartyPlatformAction, context, 0));
            response.setSuccess(Boolean.TRUE.booleanValue());
        }
        return response;
    }

    private <T extends BaseRequest, O> void addQueueNotify(PlatformContext<T, O> context, String jsonStr) {
        QueueBO queueBO = new QueueBO();
        queueBO.setNotifyUrl(context.getNotifyUrl());
        queueBO.setApplicationName(((BaseRequest)context.getRequest()).getApplicationName());
        queueBO.setDelayTime(5);
        queueBO.setRequestId(ThreadContext.getRequestId());
        queueBO.setRequestBodyBO(RequestBodyBO.builder().type(context.getNotifyType().name()).result(jsonStr).build());
        this.queueService.submitBusinessNotify(queueBO);
    }

    private <T extends BaseRequest> Message asyncExec(AbstractThirdPartyPlatformAction iThirdPartyPlatformAction, PlatformContext context) {
        int timeout = iThirdPartyPlatformAction.timeout() == null ? 5000 : iThirdPartyPlatformAction.timeout();
        ListeningExecutorService listeningExecutorService = MoreExecutors.listeningDecorator((ExecutorService)this.taskExecutor);
        ListenableFuture businessMessage = listeningExecutorService.submit(() -> iThirdPartyPlatformAction.execPlatform(context));
        try {
            return (Message)businessMessage.get((long)timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.error("TimeoutException", (Throwable)e);
            return Message.build((boolean)false).setMessage("\u8c03\u7528\u7b2c\u4e09\u65b9\u5e73\u53f0\u5931\u8d25");
        }
    }

    private <T extends BaseRequest> Message retryRequestPost(AbstractThirdPartyPlatformAction iThirdPartyPlatformAction, PlatformContext context, int retryTimes) {
        if (retryTimes > iThirdPartyPlatformAction.retryNum()) {
            log.error("\u8c03\u7528\u7b2c\u4e09\u65b9\u5e73\u53f0\u4fe1\u606f\uff0c\u91cd\u8bd5\uff1a{},\u4ecd\u7136\u5931\u8d25\uff0crequest\uff1a{}", (Object)retryTimes, (Object)context);
            return Message.build((boolean)false).setMessage("\u8c03\u7528\u7b2c\u4e09\u65b9\u5e73\u53f0\u5931\u8d25");
        }
        Message message = Message.build((boolean)false);
        try {
            message = this.asyncExec(iThirdPartyPlatformAction, context);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7b2c\u4e09\u65b9\u5e73\u53f0\u4fe1\u606f\u5931\u8d25\uff0crequest:{}\uff0c", (Object)context, (Object)e);
        }
        if (message.isSuccess()) {
            return message;
        }
        return this.retryRequestPost(iThirdPartyPlatformAction, context, ++retryTimes);
    }
}

