/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.chargephone;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.chargephone.ChargePhoneAction;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.facade.request.ChargePhoneRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IChargePhoneActionDispatcher<T extends BaseRequest, O> {
    private static final Logger log = LoggerFactory.getLogger(IChargePhoneActionDispatcher.class);
    private Map<String, ChargePhoneAction<T, O>> actionMap = new HashMap<String, ChargePhoneAction<T, O>>();

    @Autowired
    public IChargePhoneActionDispatcher(List<ChargePhoneAction<T, O>> actionList) {
        for (ChargePhoneAction<T, O> chargePhoneAction : actionList) {
            String key = chargePhoneAction.support().name();
            if (this.actionMap.containsKey(key)) {
                log.error("{}\u5df2\u7ecf\u5b58\u5728,\u5b58\u5728\u91cd\u590d\u5b9a\u4e49", (Object)key);
            }
            this.actionMap.put(key, chargePhoneAction);
        }
    }

    public Message exec(PlatformContext<T, O> context) {
        ChargePhoneRequest request = (ChargePhoneRequest)context.getRequest();
        log.info("\u53d1\u8d77\u5145\u8bdd\u8d39\u52a8\u4f5c:{}", (Object)JSON.toJSONString(context));
        ChargePhoneAction<T, O> action = this.actionMap.get(request.getChannel());
        if (null == action) {
            log.error("\u4e0d\u5b58\u5728[{}]\u5bf9\u5e94\u7684\u652f\u4ed8\u52a8\u4f5c\u5904\u7406", context);
            return null;
        }
        return action.exec(context);
    }
}

