/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.chargephone.xinrong;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.thirdparty.platform.adapter.chargephone.ChargePhoneAction;
import com.bxm.thirdparty.platform.adapter.chargephone.xinrong.bo.XinRongChargeBO;
import com.bxm.thirdparty.platform.adapter.chargephone.xinrong.bo.XinRongCreateOrderBO;
import com.bxm.thirdparty.platform.adapter.chargephone.xinrong.enums.XinRongChargeCouponEnum;
import com.bxm.thirdparty.platform.adapter.chargephone.xinrong.utils.PhoneUtil;
import com.bxm.thirdparty.platform.adapter.chargephone.xinrong.utils.XinRongUtil;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.request.ChargePhoneRequest;
import com.bxm.thirdparty.platform.facade.response.ChargePhoneTopUpResponse;
import com.bxm.thirdparty.platform.model.entity.ChargesPhoneLogEntity;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class XinRongChargePhoneAction
implements ChargePhoneAction<ChargePhoneRequest, ChargesPhoneLogEntity> {
    private static final Logger log = LoggerFactory.getLogger(XinRongChargePhoneAction.class);
    @Resource
    private ThirdPartyConfigProperties thirdPartyConfigProperties;

    @Override
    public PlatformEnum support() {
        return PlatformEnum.XIN_RONG;
    }

    @Override
    public Message exec(PlatformContext<ChargePhoneRequest, ChargesPhoneLogEntity> context) {
        BigDecimal money;
        ChargePhoneRequest request = context.getRequest();
        ChargesPhoneLogEntity orderInfo = context.getOrderInfo();
        String phoneNo = request.getPhoneNo();
        String phoneCarrier = this.getPhoneCarrier(phoneNo);
        XinRongChargeCouponEnum chargeCouponEnum = XinRongChargeCouponEnum.get(phoneCarrier, money = request.getMoney());
        if (Objects.isNull((Object)chargeCouponEnum)) {
            log.error("\u6ca1\u6709\u5339\u914d\u7684\u5145\u503c\u91d1\u989d\uff0c\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u903b\u8f91\uff0c\u91d1\u989d\u4e3a\uff1a{}", (Object)money);
            return Message.build((boolean)false).setMessage("\u5145\u503c\u91d1\u989d\u4e0d\u5b58\u5728");
        }
        XinRongUtil xinRongUtil = new XinRongUtil(this.thirdPartyConfigProperties);
        if (xinRongUtil.getAccountBalance().compareTo(money) < 0) {
            log.error("\u5fc3\u878d\u8bdd\u8d39\u5145\u503c\u5931\u8d25\uff0c\u5145\u503c\u4f59\u989d\u4e0d\u8db3\uff1a{}", (Object)request);
            return Message.build((boolean)false).setMessage("\u5145\u503c\u4f59\u989d\u4e0d\u8db3");
        }
        ChargePhoneTopUpResponse response = new ChargePhoneTopUpResponse();
        String body = xinRongUtil.topUp(request, orderInfo.getOrderNo().toString(), chargeCouponEnum);
        if (Objects.isNull(body)) {
            return Message.build((boolean)false).setBizCode("THIRD_PARTY_500").setMessage("\u8c03\u7528\u7b2c\u4e09\u65b9\u8bdd\u8d39\u5145\u503c\u5931\u8d25");
        }
        XinRongChargeBO xinRongChargeBO = (XinRongChargeBO)JSON.parseObject((String)body, XinRongChargeBO.class);
        if (Objects.isNull(xinRongChargeBO) || !Objects.equals(xinRongChargeBO.getCode(), XinRongUtil.SUCCESS_CODE)) {
            log.error("\u8c03\u53d6\u7b2c\u4e09\u65b9\u8bdd\u8d39\u5145\u503c\u5931\u8d25\uff1aparam:{},result:{}", context, (Object)body);
            return Message.build((boolean)false).setMessage("\u8c03\u53d6\u7b2c\u4e09\u65b9\u8bdd\u8d39\u5145\u503c\u5931\u8d25");
        }
        XinRongCreateOrderBO xinRongCreateOrderBO = (XinRongCreateOrderBO)JSON.parseObject((String)JSON.toJSONString(xinRongChargeBO.getData()), XinRongCreateOrderBO.class);
        response.setResult(body);
        response.setPhoneNo(phoneNo);
        response.setMoney(xinRongCreateOrderBO.getMoney());
        response.setOrderNo(orderInfo.getOrderNo().toString());
        response.setOutOrderNo(request.getOrderNo());
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)response);
    }

    private String getPhoneCarrier(String phone) {
        String carrier = PhoneUtil.getCarrier(phone);
        if (StringUtils.isBlank((CharSequence)carrier)) {
            String substring = StringUtils.substring((String)phone, (int)0, (int)3);
            if (this.thirdPartyConfigProperties.getMovePhoneParagraph().contains(substring)) {
                return "\u79fb\u52a8";
            }
            if (this.thirdPartyConfigProperties.getUmPhoneParagraph().contains(substring)) {
                return "\u8054\u901a";
            }
            if (this.thirdPartyConfigProperties.getTmPhoneParagraph().contains(substring)) {
                return "\u7535\u4fe1";
            }
        }
        return carrier;
    }
}

