/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.chargephone.xinrong.utils;

import cn.hutool.http.HttpUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.thirdparty.platform.adapter.chargephone.xinrong.bo.CheckAccountBO;
import com.bxm.thirdparty.platform.adapter.chargephone.xinrong.bo.XinRongChargeBO;
import com.bxm.thirdparty.platform.adapter.chargephone.xinrong.enums.XinRongChargeCouponEnum;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.facade.request.ChargePhoneRequest;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XinRongUtil {
    private static final Logger log = LoggerFactory.getLogger(XinRongUtil.class);
    public static final Integer SUCCESS_CODE = 200;
    private ThirdPartyConfigProperties thirdPartyConfigProperties;

    public XinRongUtil(ThirdPartyConfigProperties thirdPartyConfigProperties) {
        this.thirdPartyConfigProperties = thirdPartyConfigProperties;
    }

    public String topUp(ChargePhoneRequest request, String outLogNo, XinRongChargeCouponEnum chargeCouponEnum) {
        HashMap paramsMap = Maps.newHashMap();
        paramsMap.put("account", request.getPhoneNo());
        paramsMap.put("out_logno", outLogNo);
        paramsMap.put("productsn", chargeCouponEnum.name());
        paramsMap.put("money", chargeCouponEnum.getAmount().toString());
        Map<String, Object> requestParamMap = this.getParamMap(paramsMap, "create");
        String response = null;
        try {
            response = HttpUtil.get((String)this.thirdPartyConfigProperties.getXinRongCreateOrder(), requestParamMap);
        }
        catch (Exception e) {
            log.info("\u8c03\u53d6\u7b2c\u4e09\u65b9\u8bdd\u8d39\u5145\u503c\u5931\u8d25\uff1aparam:{},exception:{}", (Object)JSON.toJSONString(requestParamMap), (Object)e);
            return null;
        }
        return response;
    }

    public BigDecimal getAccountBalance() {
        HashMap paramsMap = Maps.newHashMap();
        paramsMap.put("query_type", "1");
        Map<String, Object> requestParamMap = this.getParamMap(paramsMap, "checkaccount");
        String resultDto = null;
        try {
            resultDto = HttpUtil.get((String)this.thirdPartyConfigProperties.getXinRongCheckAccount(), requestParamMap);
        }
        catch (Exception e) {
            log.info("\u8c03\u53d6\u7b2c\u4e09\u65b9\u8bdd\u8d39\u4f59\u989d\u67e5\u8be2\u5931\u8d25\uff1aparam:{},exception:{}", (Object)JSON.toJSONString(requestParamMap), (Object)e);
            return BigDecimal.ZERO;
        }
        log.info("\u8c03\u53d6\u7b2c\u4e09\u65b9\u8bdd\u8d39\u4f59\u989d\u67e5\u8be2\uff1aparam:{},result:{}", (Object)JSON.toJSONString(requestParamMap), (Object)resultDto);
        XinRongChargeBO xinRongChargeBO = (XinRongChargeBO)JSON.parseObject((String)resultDto, XinRongChargeBO.class);
        if (Objects.nonNull(xinRongChargeBO) && Objects.equals(SUCCESS_CODE, xinRongChargeBO.getCode())) {
            CheckAccountBO checkAccountBO = (CheckAccountBO)JSON.parseObject((String)JSON.toJSONString(xinRongChargeBO.getData()), CheckAccountBO.class);
            return checkAccountBO.getBalance();
        }
        log.error("\u8c03\u53d6\u7b2c\u4e09\u65b9\u8bdd\u8d39\u67e5\u8be2\u4f59\u989d\u5931\u8d25param:{},\uff1a{}", requestParamMap, (Object)resultDto);
        return BigDecimal.ZERO;
    }

    private Map<String, Object> getParamMap(Map<String, String> paramMap, String type) {
        HashMap params = Maps.newHashMap();
        params.put("client_id", this.thirdPartyConfigProperties.getXinRongClientId());
        params.put("type", type);
        params.put("data_type", "JSON");
        params.put("body", JSON.toJSONString(paramMap));
        params.put("sign", this.getSign(paramMap));
        return params;
    }

    private String getSign(Map<String, String> params) {
        Set<String> keyList = params.keySet();
        ArrayList<String> list = new ArrayList<String>(keyList);
        Collections.sort(list);
        StringBuilder sb = new StringBuilder();
        sb.append(this.thirdPartyConfigProperties.getXinRongClientSecret());
        for (String key : list) {
            sb.append(key).append(params.get(key));
        }
        sb.append(this.thirdPartyConfigProperties.getXinRongClientSecret());
        return MD5Util.standardMd5((String)sb.toString()).toUpperCase();
    }
}

