/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.electric.liba.utils;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.thirdparty.platform.adapter.electric.liba.bo.LiBaBO;
import com.bxm.thirdparty.platform.adapter.electric.liba.bo.LiBaCheckAccountBO;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiBaUtil {
    private static final Logger log = LoggerFactory.getLogger(LiBaUtil.class);
    private ThirdPartyConfigProperties thirdPartyConfigProperties;

    public LiBaUtil(ThirdPartyConfigProperties thirdPartyConfigProperties) {
        this.thirdPartyConfigProperties = thirdPartyConfigProperties;
    }

    public String createOrder(Map<String, Object> paramMap) {
        paramMap.put("appId", this.thirdPartyConfigProperties.getLiBaAppId());
        paramMap.put("timestamp", DateUtil.current());
        paramMap.put("sign", this.getSign(paramMap));
        HttpRequest httpRequest = HttpUtil.createPost((String)this.thirdPartyConfigProperties.getLiBaCreateOrderApi());
        httpRequest.contentType("multipart/form-data");
        httpRequest.form(paramMap);
        HttpResponse execute = null;
        try {
            execute = httpRequest.execute();
            log.info("\u8bf7\u6c42\u529b\u62d4\u7535\u8d39\u5145\u503c\uff0c\u8bf7\u6c42\u4f53\uff1a{}\uff0c\u8fd4\u56de\u4f53\uff1a{}", paramMap, (Object)execute.body());
            return execute.body();
        }
        catch (Exception e) {
            log.error("liba\u8bdd\u8d39\u5145\u503c\u5931\u8d25\uff0c\u8bf7\u6c42\u529b\u62d4\u63a5\u53e3\u62a5\u9519\uff1a{}", paramMap, (Object)e);
            return null;
        }
    }

    public BigDecimal checkAccount() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", this.thirdPartyConfigProperties.getLiBaAppId());
        paramMap.put("timestamp", DateUtil.current());
        paramMap.put("sign", this.getSign(paramMap));
        HttpRequest httpRequest = HttpUtil.createPost((String)this.thirdPartyConfigProperties.getLiBaCheckAccountApi());
        httpRequest.contentType("multipart/form-data");
        httpRequest.form(paramMap);
        HttpResponse execute = null;
        try {
            String body;
            LiBaBO liBaBO;
            execute = httpRequest.execute();
            log.info("\u8bf7\u6c42\u529b\u62d4\u7535\u8d39\u5145\u503c\u8d26\u6237\u4f59\u989d\uff0c\u8bf7\u6c42\u4f53\uff1a{}\uff0c\u8fd4\u56de\u4f53\uff1a{}", paramMap, (Object)execute.body());
            if (execute.isOk() && Objects.nonNull(liBaBO = (LiBaBO)JSON.parseObject((String)(body = execute.body()), LiBaBO.class)) && Objects.equals(liBaBO.getReturnCode(), 200)) {
                LiBaCheckAccountBO liBaCheckAccountBO = (LiBaCheckAccountBO)JSON.parseObject((String)JSON.toJSONString(liBaBO.getData()), LiBaCheckAccountBO.class);
                return liBaCheckAccountBO.getAmountBalance();
            }
            return BigDecimal.ZERO;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528liba\u7b2c\u4e09\u65b9\u670d\u52a1\u5931\u8d25paramMap:{},e:{}", paramMap, (Object)e.getMessage());
            return BigDecimal.ZERO;
        }
    }

    private String getSign(Map<String, Object> params) {
        Set<String> keyList = params.keySet();
        ArrayList<String> list = new ArrayList<String>(keyList);
        Collections.sort(list);
        StringBuilder sb = new StringBuilder();
        for (String key : list) {
            sb.append(key).append(params.get(key)).append("&");
        }
        sb.append(this.thirdPartyConfigProperties.getLiBaAppKey());
        return MD5Util.standardMd5((String)sb.toString()).toUpperCase();
    }
}

