/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.payment;

import cn.hutool.core.bean.BeanUtil;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.AbstractThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.adapter.payment.IPaymentActionDispatcher;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentModeEnum;
import com.bxm.thirdparty.platform.adapter.payment.request.PaymentRequest;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.facade.request.PaymentPreRequest;
import com.bxm.thirdparty.platform.model.entity.PaymentOrderV2Entity;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class PrePaymentPlatformAction<T extends PaymentRequest>
extends AbstractThirdPartyPlatformAction<PaymentPreRequest, PaymentOrderV2Entity> {
    @Resource
    private IPaymentActionDispatcher iPaymentActionDispatcher;

    @Override
    public Message exec(PlatformContext<PaymentPreRequest, PaymentOrderV2Entity> context) {
        PaymentPreRequest request = context.getRequest();
        PaymentOrderV2Entity orderInfo = context.getOrderInfo();
        PaymentRequest paymentRequest = new PaymentRequest();
        paymentRequest.setPlatform(PlatformEnum.get(request.getPayPlatform()));
        paymentRequest.setMode(PaymentModeEnum.get(request.getPayMode()));
        paymentRequest.setAction(PaymentActionEnum.PRE_PAYMENT);
        paymentRequest.setRequestOrderNo(orderInfo.getOrderNo().toString());
        PaymentRequest methodParamClass = this.iPaymentActionDispatcher.getMethodParamClass(paymentRequest);
        methodParamClass.setPlatform(PlatformEnum.get(request.getPayPlatform()));
        methodParamClass.setMode(PaymentModeEnum.get(request.getPayMode()));
        methodParamClass.setAction(PaymentActionEnum.PRE_PAYMENT);
        methodParamClass.setRequestOrderNo(orderInfo.getOrderNo().toString());
        BeanUtil.copyProperties((Object)request, (Object)methodParamClass, (String[])new String[0]);
        return this.iPaymentActionDispatcher.exec(methodParamClass);
    }

    @Override
    public Class<? extends BaseRequest> support() {
        return PaymentPreRequest.class;
    }

    @Override
    protected Message mockResult(PlatformContext<PaymentPreRequest, PaymentOrderV2Entity> context) {
        return null;
    }
}

