/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.payment;

import cn.hutool.core.bean.BeanUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.AbstractThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.adapter.payment.IPaymentActionDispatcher;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.request.PaymentRequest;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.notify.RefundNotifyResponse;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.facade.request.PaymentRefundRequest;
import com.bxm.thirdparty.platform.facade.response.RefundResponse;
import com.bxm.thirdparty.platform.model.entity.PaymentOrderV2Entity;
import com.bxm.thirdparty.platform.model.entity.PaymentRefundV2Entity;
import com.bxm.thirdparty.platform.queue.QueueService;
import com.bxm.thirdparty.platform.queue.bo.QueueBO;
import com.bxm.thirdparty.platform.queue.bo.RequestBodyBO;
import com.bxm.thirdparty.platform.service.PaymentService;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class RefundPlatformAction<T extends PaymentRequest>
extends AbstractThirdPartyPlatformAction<PaymentRefundRequest, PaymentRefundV2Entity> {
    @Resource
    IPaymentActionDispatcher iPaymentActionDispatcher;
    @Resource
    private PaymentService paymentService;
    @Resource
    private QueueService queueService;

    @Override
    public Message exec(PlatformContext<PaymentRefundRequest, PaymentRefundV2Entity> context) {
        PaymentRefundRequest request = context.getRequest();
        PaymentRefundV2Entity refundV2Entity = context.getOrderInfo();
        PaymentOrderV2Entity paymentOrder = (PaymentOrderV2Entity)JSON.parseObject((String)context.getExtStr(), PaymentOrderV2Entity.class);
        PaymentRequest paymentRequest = new PaymentRequest();
        paymentRequest.setPlatform(PlatformEnum.get(paymentOrder.getPayPlatform()));
        paymentRequest.setAction(PaymentActionEnum.REFUND);
        PaymentRequest methodParamClass = this.iPaymentActionDispatcher.getMethodParamClass(paymentRequest);
        methodParamClass.setPlatform(PlatformEnum.get(paymentOrder.getPayPlatform()));
        methodParamClass.setAction(PaymentActionEnum.REFUND);
        methodParamClass.setRequestOrderNo(refundV2Entity.getRefundOrderNo().toString());
        BeanUtil.copyProperties((Object)request, (Object)methodParamClass, (String[])new String[0]);
        Message exec = this.iPaymentActionDispatcher.exec(methodParamClass);
        if (exec.isSuccess()) {
            if (Objects.equals((Object)paymentRequest.getPlatform(), (Object)PlatformEnum.ALI)) {
                RefundResponse refundResponse = (RefundResponse)exec.getParam(CommonConstant.RESULT_DTO);
                RefundNotifyResponse refundNotifyResponse = new RefundNotifyResponse();
                if (refundResponse.getSuccess().booleanValue()) {
                    this.paymentService.updateRefundOrderSuccess(refundV2Entity.getRefundOrderNo());
                    refundNotifyResponse.setSuccess(Boolean.valueOf(true));
                    refundNotifyResponse.setPaymentOrderNo(paymentOrder.getOrderNo().toString());
                    refundNotifyResponse.setRefundOrderNo(refundV2Entity.getRefundOrderNo().toString());
                    refundNotifyResponse.setOutOrderNo(request.getRefundOrderNo());
                } else {
                    this.paymentService.updateRefundOrderFail(refundV2Entity.getRefundOrderNo(), refundResponse.getErrorMsg());
                    refundNotifyResponse.setSuccess(Boolean.valueOf(false));
                    refundNotifyResponse.setErrorMsg(refundResponse.getErrorMsg());
                }
                this.businessSubmit(context, refundNotifyResponse);
            } else {
                this.paymentService.updateRefundOrderRefundIng(refundV2Entity.getRefundOrderNo());
            }
        } else {
            this.paymentService.updateRefundOrderFail(refundV2Entity.getRefundOrderNo(), exec.getLastMessage());
        }
        return exec;
    }

    private void businessSubmit(PlatformContext<PaymentRefundRequest, PaymentRefundV2Entity> context, RefundNotifyResponse refundNotifyResponse) {
        QueueBO queueBO = new QueueBO();
        queueBO.setApplicationName(context.getRequest().getApplicationName());
        queueBO.setRequestId(context.getRequestId());
        queueBO.setRequestBodyBO(RequestBodyBO.builder().type(context.getNotifyType().name()).result(JSON.toJSONString((Object)refundNotifyResponse)).build());
        this.queueService.submitBusinessNotify(queueBO);
    }

    @Override
    public Class<? extends BaseRequest> support() {
        return PaymentRefundRequest.class;
    }

    @Override
    protected Message mockResult(PlatformContext<PaymentRefundRequest, PaymentRefundV2Entity> context) {
        PaymentRefundV2Entity orderInfo = context.getOrderInfo();
        RefundResponse refundResponse = new RefundResponse();
        refundResponse.setSuccess(Boolean.valueOf(true));
        refundResponse.setOutOrderNo(orderInfo.getOutOrderNo());
        refundResponse.setPaymentOrderNo(orderInfo.getPaymentOrderNo().toString());
        refundResponse.setRefundOrderNo(orderInfo.getRefundOrderNo().toString());
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)refundResponse);
    }
}

