/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.payment;

import cn.hutool.core.bean.BeanUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.adapter.AbstractThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.adapter.payment.IPaymentActionDispatcher;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.request.PaymentRequest;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.notify.WithdrawNotifyResponse;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.facade.request.WithdrawRequest;
import com.bxm.thirdparty.platform.facade.response.WithdrawResponse;
import com.bxm.thirdparty.platform.model.entity.PaymentWithdrawFlowV2Entity;
import com.bxm.thirdparty.platform.queue.QueueService;
import com.bxm.thirdparty.platform.queue.bo.QueueBO;
import com.bxm.thirdparty.platform.queue.bo.RequestBodyBO;
import com.bxm.thirdparty.platform.service.PaymentService;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class WithdrawPlatformAction<T extends PaymentRequest>
extends AbstractThirdPartyPlatformAction<WithdrawRequest, PaymentWithdrawFlowV2Entity> {
    @Resource
    IPaymentActionDispatcher iPaymentActionDispatcher;
    @Resource
    private PaymentService paymentService;
    @Resource
    private QueueService queueService;

    @Override
    public Message exec(PlatformContext<WithdrawRequest, PaymentWithdrawFlowV2Entity> context) {
        PaymentWithdrawFlowV2Entity orderInfo = context.getOrderInfo();
        PaymentRequest paymentRequest = new PaymentRequest();
        paymentRequest.setPlatform(PlatformEnum.get(context.getRequest().getPayPlatform()));
        paymentRequest.setAction(PaymentActionEnum.TRANSFERS);
        paymentRequest.setRequestOrderNo(orderInfo.getWithdrawOrderNo().toString());
        PaymentRequest methodParamClass = this.iPaymentActionDispatcher.getMethodParamClass(paymentRequest);
        methodParamClass.setPlatform(PlatformEnum.get(context.getRequest().getPayPlatform()));
        methodParamClass.setAction(PaymentActionEnum.TRANSFERS);
        methodParamClass.setRequestOrderNo(orderInfo.getWithdrawOrderNo().toString());
        BeanUtil.copyProperties((Object)context.getRequest(), (Object)methodParamClass, (String[])new String[0]);
        Message exec = this.iPaymentActionDispatcher.exec(methodParamClass);
        if (exec.isSuccess()) {
            if (Objects.equals((Object)paymentRequest.getPlatform(), (Object)PlatformEnum.ALI) || Objects.equals((Object)paymentRequest.getPlatform(), (Object)PlatformEnum.WX)) {
                WithdrawResponse refundResponse = (WithdrawResponse)exec.getParam(CommonConstant.RESULT_DTO);
                WithdrawNotifyResponse response = new WithdrawNotifyResponse();
                if (refundResponse.getSuccess().booleanValue()) {
                    this.paymentService.updateWithdrawOrderSuccess(orderInfo.getWithdrawOrderNo());
                    response.setSuccess(Boolean.valueOf(true));
                    response.setOrderNo(orderInfo.getWithdrawOrderNo().toString());
                    response.setOutOrderNo(context.getRequest().getOrderNo());
                } else {
                    this.paymentService.updateWithdrawOrderFail(orderInfo.getWithdrawOrderNo(), refundResponse.getErrorMsg());
                    response.setSuccess(Boolean.valueOf(false));
                    response.setErrorMsg(refundResponse.getErrorMsg());
                }
                this.businessSubmit(context, response);
            }
        } else {
            this.paymentService.updateWithdrawOrderFail(orderInfo.getWithdrawOrderNo(), exec.getLastMessage());
        }
        return exec;
    }

    private void businessSubmit(PlatformContext<WithdrawRequest, PaymentWithdrawFlowV2Entity> context, WithdrawNotifyResponse response) {
        PaymentWithdrawFlowV2Entity orderInfo = context.getOrderInfo();
        QueueBO queueBO = new QueueBO();
        queueBO.setDelayTime(3);
        queueBO.setApplicationName(context.getRequest().getApplicationName());
        queueBO.setRequestId(orderInfo.getRequestId());
        queueBO.setRequestBodyBO(RequestBodyBO.builder().type(context.getNotifyType().name()).result(JSON.toJSONString((Object)response)).build());
        this.queueService.submitBusinessNotify(queueBO);
    }

    @Override
    public Class<? extends BaseRequest> support() {
        return WithdrawRequest.class;
    }

    @Override
    protected Message mockResult(PlatformContext<WithdrawRequest, PaymentWithdrawFlowV2Entity> context) {
        PaymentWithdrawFlowV2Entity orderInfo = context.getOrderInfo();
        WithdrawResponse response = new WithdrawResponse();
        response.setSuccess(Boolean.valueOf(true));
        response.setOutOrderNo(orderInfo.getOutTrackNo());
        response.setWithdrawOrderNo(orderInfo.getWithdrawOrderNo().toString());
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)response);
    }
}

