/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.payment.pay.ali;

import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.payment.facade.PaymentConfigFacadeService;
import com.bxm.thirdparty.platform.adapter.payment.PayPlatformAction;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentModeEnum;
import com.bxm.thirdparty.platform.adapter.payment.pay.ali.request.AliH5PrePaymentRequest;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.response.PrePaymentResponse;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AliH5PreOrderAction
extends PayPlatformAction<AliH5PrePaymentRequest> {
    private static final Logger log = LoggerFactory.getLogger(AliH5PreOrderAction.class);
    @Resource
    private PaymentConfigFacadeService paymentConfigFacadeService;
    @Resource
    private ThirdPartyConfigProperties configProperties;

    @Override
    protected Message exec(AliH5PrePaymentRequest request) {
        AlipayClient alipayClient = this.paymentConfigFacadeService.getAliClientByMchId(request.getAccountId());
        if (Objects.isNull(alipayClient)) {
            return Message.build((boolean)false).setMessage("\u652f\u4ed8\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        PrePaymentResponse prePaymentResponse = new PrePaymentResponse();
        if (request.getMock().booleanValue()) {
            return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)prePaymentResponse);
        }
        AlipayTradeWapPayRequest alipayRequest = new AlipayTradeWapPayRequest();
        alipayRequest.setBizModel((AlipayObject)this.createWapPayModel(request, request.getRequestOrderNo()));
        alipayRequest.setNotifyUrl(this.configProperties.getServerUrl() + this.configProperties.getAliPayCallbackUrl());
        AlipayResponse execute = null;
        try {
            execute = alipayClient.pageExecute((AlipayRequest)alipayRequest);
            prePaymentResponse.setLink(execute.getBody());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u9884\u652f\u4ed8\u5931\u8d25\uff0cparam:{},exception\uff1a", (Object)request, (Object)e);
            return Message.build((boolean)false).setMessage("\u8c03\u7528\u652f\u4ed8\u5b9d\u9884\u652f\u4ed8\u5931\u8d25" + e.getMessage());
        }
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)prePaymentResponse);
    }

    private AlipayTradeWapPayModel createWapPayModel(AliH5PrePaymentRequest request, String trackNo) {
        BigDecimal amount = request.getAmount().setScale(2, RoundingMode.DOWN);
        AlipayTradeWapPayModel model = new AlipayTradeWapPayModel();
        model.setOutTradeNo(trackNo);
        model.setTotalAmount(amount.toString());
        model.setSubject(request.getTitle());
        model.setProductCode("QUICK_WAP_WAY");
        model.setQuitUrl(request.getQuitUrl());
        model.setBody(request.getOrderDescription());
        model.setTimeoutExpress("30m");
        return model;
    }

    @Override
    protected PaymentModeEnum matchMode() {
        return PaymentModeEnum.H5;
    }

    @Override
    protected PaymentActionEnum matchAction() {
        return PaymentActionEnum.PRE_PAYMENT;
    }

    @Override
    protected PlatformEnum platform() {
        return PlatformEnum.ALI;
    }
}

