/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.payment.pay.wx;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.payment.facade.PaymentConfigFacadeService;
import com.bxm.thirdparty.platform.adapter.payment.PayPlatformAction;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentModeEnum;
import com.bxm.thirdparty.platform.adapter.payment.pay.wx.request.WxH5PrePayRequest;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.response.PrePaymentResponse;
import com.github.binarywang.wxpay.bean.order.WxPayMwebOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WxH5PreOrderAction
extends PayPlatformAction<WxH5PrePayRequest> {
    private static final Logger log = LoggerFactory.getLogger(WxH5PreOrderAction.class);
    @Resource
    private PaymentConfigFacadeService paymentConfigFacadeService;
    @Resource
    private ThirdPartyConfigProperties partyConfigProperties;

    @Override
    public Message exec(WxH5PrePayRequest request) {
        WxPayService wxPayService = this.paymentConfigFacadeService.getWxClientByMchId(request.getAccountId());
        if (Objects.isNull(wxPayService)) {
            return Message.build((boolean)false).setMessage("\u652f\u4ed8\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        PrePaymentResponse prePaymentResponse = new PrePaymentResponse();
        if (request.getMock().booleanValue()) {
            return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)prePaymentResponse);
        }
        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = new WxPayUnifiedOrderRequest();
        wxPayUnifiedOrderRequest.setDeviceInfo("WEB");
        wxPayUnifiedOrderRequest.setOutTradeNo(request.getRequestOrderNo());
        wxPayUnifiedOrderRequest.setBody(request.getOrderDescription());
        wxPayUnifiedOrderRequest.setTotalFee(BaseWxPayRequest.yuanToFen((String)request.getAmount().toString()));
        wxPayUnifiedOrderRequest.setSpbillCreateIp(request.getRequestIp());
        wxPayUnifiedOrderRequest.setTradeType("MWEB");
        wxPayUnifiedOrderRequest.setNotifyUrl(this.partyConfigProperties.getServerUrl() + this.partyConfigProperties.getAliPayCallbackUrl());
        try {
            WxPayMwebOrderResult execute = (WxPayMwebOrderResult)wxPayService.createOrder(wxPayUnifiedOrderRequest);
            prePaymentResponse.setLink(execute.getMwebUrl());
        }
        catch (WxPayException e) {
            log.error("\u8c03\u7528\u5fae\u4fe1H5\u9884\u652f\u4ed8\u5931\u8d25\uff0cparam:{},exception\uff1a", (Object)request, (Object)e);
            return Message.build((boolean)false).setMessage("\u8c03\u7528\u5fae\u4fe1H5\u9884\u652f\u4ed8\u5931\u8d25" + e.getMessage());
        }
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)prePaymentResponse);
    }

    @Override
    protected PaymentActionEnum matchAction() {
        return PaymentActionEnum.PRE_PAYMENT;
    }

    @Override
    protected PaymentModeEnum matchMode() {
        return PaymentModeEnum.H5;
    }

    @Override
    protected PlatformEnum platform() {
        return PlatformEnum.WX;
    }
}

