/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.payment.withdraw.ali;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.request.AlipayFundTransUniTransferRequest;
import com.alipay.api.response.AlipayFundTransUniTransferResponse;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.payment.facade.PaymentConfigFacadeService;
import com.bxm.thirdparty.platform.adapter.payment.PayPlatformAction;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.withdraw.ali.param.AlipayFundTransUniTransferParam;
import com.bxm.thirdparty.platform.adapter.payment.withdraw.ali.param.AlipayFundTransUniTransferPayeeInfoParam;
import com.bxm.thirdparty.platform.adapter.payment.withdraw.ali.request.AliWithdrawRequest;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.response.WithdrawResponse;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AliWithdrawPreOrderAction
extends PayPlatformAction<AliWithdrawRequest> {
    private static final Logger log = LoggerFactory.getLogger(AliWithdrawPreOrderAction.class);
    @Resource
    private PaymentConfigFacadeService paymentConfigFacadeService;

    @Override
    public Message exec(AliWithdrawRequest request) {
        AlipayClient alipayClient = this.paymentConfigFacadeService.getAliClientByMchId(request.getAccountId());
        if (Objects.isNull(alipayClient)) {
            return Message.build((boolean)false).setMessage("\u63d0\u73b0\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        AlipayFundTransUniTransferRequest transferRequest = new AlipayFundTransUniTransferRequest();
        AlipayFundTransUniTransferPayeeInfoParam payeeInfoParam = new AlipayFundTransUniTransferPayeeInfoParam();
        payeeInfoParam.setIdentityType("ALIPAY_LOGON_ID");
        payeeInfoParam.setIdentity(request.getRealName());
        payeeInfoParam.setName(request.getRealName());
        AlipayFundTransUniTransferParam transUniTransferParam = new AlipayFundTransUniTransferParam();
        transUniTransferParam.setOutBizNo(request.getRequestOrderNo());
        transUniTransferParam.setTransAmount(request.getAmount());
        transUniTransferParam.setProductCode("TRANS_ACCOUNT_NO_PWD");
        transUniTransferParam.setBizScene("DIRECT_TRANSFER");
        transUniTransferParam.setOrderTitle(request.getTitle());
        transUniTransferParam.setPayeeInfo(payeeInfoParam);
        transUniTransferParam.setRemark(request.getRemark());
        transferRequest.setBizContent(JSON.toJSONString((Object)transUniTransferParam));
        WithdrawResponse response = new WithdrawResponse();
        try {
            AlipayFundTransUniTransferResponse transferResponse = (AlipayFundTransUniTransferResponse)alipayClient.certificateExecute((AlipayRequest)transferRequest);
            response.setSuccess(Boolean.valueOf(Objects.equals(transferResponse.getStatus(), "SUCCESS")));
            response.setErrorMsg(transferResponse.getSubMsg());
            response.setResult(JSON.toJSONString((Object)transferResponse));
            response.setOutOrderNo(request.getOrderNo());
            response.setWithdrawOrderNo(request.getRequestOrderNo());
        }
        catch (AlipayApiException e) {
            log.error("\u652f\u4ed8\u5b9d\u8f6c\u8d26\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)request);
            log.error(e.getMessage(), (Throwable)e);
            return Message.build((boolean)false).setMessage(e.getErrMsg());
        }
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)response);
    }

    @Override
    protected PaymentActionEnum matchAction() {
        return PaymentActionEnum.TRANSFERS;
    }

    @Override
    protected PlatformEnum platform() {
        return PlatformEnum.ALI;
    }
}

