/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.adapter.payment.withdraw.wx;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.payment.facade.PaymentConfigFacadeService;
import com.bxm.thirdparty.platform.adapter.payment.PayPlatformAction;
import com.bxm.thirdparty.platform.adapter.payment.enums.PaymentActionEnum;
import com.bxm.thirdparty.platform.adapter.payment.withdraw.wx.request.WxWithdrawRequest;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.response.WithdrawResponse;
import com.github.binarywang.wxpay.bean.entpay.EntPayRequest;
import com.github.binarywang.wxpay.bean.entpay.EntPayResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WxWithdrawAction
extends PayPlatformAction<WxWithdrawRequest> {
    private static final Logger log = LoggerFactory.getLogger(WxWithdrawAction.class);
    @Resource
    private PaymentConfigFacadeService paymentConfigFacadeService;

    @Override
    public Message exec(WxWithdrawRequest request) {
        WxPayService wxPayService = this.paymentConfigFacadeService.getWxClientByMchId(request.getAccountId());
        if (Objects.isNull(wxPayService)) {
            return Message.build((boolean)false).setMessage("\u63d0\u73b0\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        WithdrawResponse withdrawResponse = new WithdrawResponse();
        EntPayRequest entPayRequest = new EntPayRequest();
        entPayRequest.setAmount(BaseWxPayRequest.yuanToFen((String)request.getAmount().toString()));
        entPayRequest.setAppid(request.getAppId());
        entPayRequest.setOpenid(request.getIdentity());
        entPayRequest.setCheckName("NO_CHECK");
        entPayRequest.setDescription(request.getRemark());
        entPayRequest.setPartnerTradeNo(request.getRequestOrderNo().toString());
        entPayRequest.setSpbillCreateIp(request.getRequestIp());
        try {
            EntPayResult result = wxPayService.getEntPayService().entPay(entPayRequest);
            withdrawResponse.setResult(JSON.toJSONString((Object)result));
            if (Objects.equals(result.getReturnCode(), "SUCCESS") && Objects.equals(result.getResultCode(), "SUCCESS")) {
                withdrawResponse.setSuccess(Boolean.valueOf(true));
            } else {
                withdrawResponse.setSuccess(Boolean.valueOf(false));
                withdrawResponse.setErrorMsg(result.getReturnMsg());
            }
            withdrawResponse.setOutOrderNo(request.getOrderNo());
            withdrawResponse.setWithdrawOrderNo(request.getRequestOrderNo().toString());
        }
        catch (WxPayException e) {
            log.error(e.getMessage(), (Throwable)e);
            log.error("\u53d1\u8d77\u63d0\u73b0\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)request);
            return Message.build((boolean)false).setMessage("\u5fae\u4fe1\u63d0\u73b0\u5931\u8d25\uff1a" + e.getErrCodeDes());
        }
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)withdrawResponse);
    }

    @Override
    protected PaymentActionEnum matchAction() {
        return PaymentActionEnum.TRANSFERS;
    }

    @Override
    protected PlatformEnum platform() {
        return PlatformEnum.WX;
    }
}

