/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.before.chargephone;

import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.before.IBeforeThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.enums.PlatformBusinessTypeEnum;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.request.ChargePhoneRequest;
import com.bxm.thirdparty.platform.mapper.ChargesPhoneLogMapper;
import com.bxm.thirdparty.platform.model.entity.ChargesPhoneLogEntity;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class BeforeChargePhoneAction
implements IBeforeThirdPartyPlatformAction<ChargePhoneRequest, ChargesPhoneLogEntity> {
    @Resource
    private SequenceCreater sequenceCreater;
    @Resource
    ChargesPhoneLogMapper chargesPhoneLogMapper;
    @Resource
    private ThirdPartyConfigProperties configProperties;

    @Override
    public Class<?> support() {
        return ChargePhoneRequest.class;
    }

    @Override
    public Message validationArgs(PlatformContext<ChargePhoneRequest, ChargesPhoneLogEntity> context) {
        ChargePhoneRequest request = context.getRequest();
        String channel = request.getChannel() == null ? this.configProperties.getDefaultChargePhoneChannel() : request.getChannel();
        request.setChannel(channel);
        if (Objects.isNull(request.getMoney()) || Objects.isNull(request.getOrderNo()) || Objects.isNull(request.getPhoneNo()) || Objects.isNull(request.getApplicationName())) {
            return Message.build((boolean)false).setMessage("\u53c2\u6570\u7f3a\u5931");
        }
        List<String> platformListByBusinessType = PlatformEnum.getPlatformListByBusinessType(PlatformBusinessTypeEnum.CHARGE_PHONE);
        if (!platformListByBusinessType.contains(channel)) {
            return Message.build((boolean)false).setMessage(channel + "\u8bdd\u8d39\u5145\u503c\u5e73\u53f0\u6682\u672a\u5b9e\u73b0");
        }
        context.setMock(request.getMock());
        context.setSync(Boolean.FALSE);
        return Message.build();
    }

    @Override
    public void insertInfo(PlatformContext<ChargePhoneRequest, ChargesPhoneLogEntity> context) {
        ChargePhoneRequest request = context.getRequest();
        ChargesPhoneLogEntity chargesPhoneLogEntity = new ChargesPhoneLogEntity();
        chargesPhoneLogEntity.setId(this.sequenceCreater.nextLongId());
        chargesPhoneLogEntity.setOrderNo(SequenceHolder.nextLongId());
        chargesPhoneLogEntity.setOutOrderNo(request.getOrderNo());
        chargesPhoneLogEntity.setPhone(request.getPhoneNo());
        chargesPhoneLogEntity.setCreateTime(new Date());
        chargesPhoneLogEntity.setPayPrice(request.getMoney());
        chargesPhoneLogEntity.setMock(Integer.valueOf(request.getMock() != false ? 1 : 0));
        chargesPhoneLogEntity.setPlatform(request.getChannel());
        chargesPhoneLogEntity.setApplicationName(request.getApplicationName());
        chargesPhoneLogEntity.setRequestId(ThreadContext.getRequestId());
        this.chargesPhoneLogMapper.insert((Object)chargesPhoneLogEntity);
        context.setOrderInfo(chargesPhoneLogEntity);
    }
}

