/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.before.electric;

import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.before.IBeforeThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.config.ThirdPartyConfigProperties;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.enums.PlatformBusinessTypeEnum;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.request.ElectricRequest;
import com.bxm.thirdparty.platform.mapper.ElectricLogMapper;
import com.bxm.thirdparty.platform.model.entity.ElectricLogEntity;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class BeforeElectricAction
implements IBeforeThirdPartyPlatformAction<ElectricRequest, ElectricLogEntity> {
    @Resource
    private SequenceCreater sequenceCreater;
    @Resource
    private ThirdPartyConfigProperties configProperties;
    @Resource
    private ElectricLogMapper electricLogMapper;

    @Override
    public Class<?> support() {
        return ElectricRequest.class;
    }

    @Override
    public Message validationArgs(PlatformContext<ElectricRequest, ElectricLogEntity> context) {
        ElectricRequest request = context.getRequest();
        String channel = request.getChannel() == null ? this.configProperties.getDefaultChargePhoneChannel() : request.getChannel();
        request.setChannel(channel);
        if (Objects.isNull(request.getAccount()) || Objects.isNull(request.getAmount()) || Objects.isNull(request.getProvince()) || Objects.isNull(request.getCity()) || Objects.isNull(request.getOrderNo()) || Objects.isNull(request.getApplicationName())) {
            return Message.build((boolean)false).setMessage("\u53c2\u6570\u7f3a\u5931");
        }
        List<String> platformListByBusinessType = PlatformEnum.getPlatformListByBusinessType(PlatformBusinessTypeEnum.ELECTRIC);
        if (!platformListByBusinessType.contains(channel)) {
            return Message.build((boolean)false).setMessage(channel + "\u7535\u8d39\u5145\u503c\u5e73\u53f0\u6682\u672a\u5b9e\u73b0");
        }
        context.setMock(request.getMock());
        context.setSync(Boolean.FALSE);
        return Message.build();
    }

    @Override
    public void insertInfo(PlatformContext<ElectricRequest, ElectricLogEntity> context) {
        ElectricRequest request = context.getRequest();
        ElectricLogEntity electricLogEntity = new ElectricLogEntity();
        electricLogEntity.setId(this.sequenceCreater.nextLongId());
        electricLogEntity.setOrderNo(SequenceHolder.nextLongId());
        electricLogEntity.setOutOrderNo(request.getOrderNo());
        electricLogEntity.setProvince(request.getProvince());
        electricLogEntity.setCity(request.getCity());
        electricLogEntity.setAccount(request.getAccount());
        electricLogEntity.setCreateTime(new Date());
        electricLogEntity.setAmount(request.getAmount());
        electricLogEntity.setMock(Integer.valueOf(request.getMock() != false ? 1 : 0));
        electricLogEntity.setPlatform(request.getChannel());
        electricLogEntity.setApplicationName(request.getApplicationName());
        electricLogEntity.setRequestId(ThreadContext.getRequestId());
        this.electricLogMapper.insert((Object)electricLogEntity);
        context.setOrderInfo(electricLogEntity);
    }
}

