/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.before.withdraw;

import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.before.IBeforeThirdPartyPlatformAction;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.enums.PlatformBusinessTypeEnum;
import com.bxm.thirdparty.platform.enums.PlatformEnum;
import com.bxm.thirdparty.platform.facade.request.WithdrawRequest;
import com.bxm.thirdparty.platform.mapper.PaymentWithdrawFlowV2Mapper;
import com.bxm.thirdparty.platform.model.entity.PaymentWithdrawFlowV2Entity;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BeforeWithdrawAction
implements IBeforeThirdPartyPlatformAction {
    private static final Logger log = LoggerFactory.getLogger(BeforeWithdrawAction.class);
    @Resource
    private PaymentWithdrawFlowV2Mapper withdrawFlowV2Mapper;
    @Resource
    private SequenceCreater sequenceCreater;

    @Override
    public Class<?> support() {
        return WithdrawRequest.class;
    }

    public Message validationArgs(PlatformContext context) {
        WithdrawRequest request = (WithdrawRequest)context.getRequest();
        String payPlatform = request.getPayPlatform();
        if (Objects.isNull(payPlatform)) {
            return Message.build((boolean)false).setMessage("\u8bf7\u6307\u5b9a\u652f\u4ed8\u5e73\u53f0");
        }
        if (Objects.isNull(request.getAccountId()) || Objects.isNull(request.getAmount()) || Objects.isNull(request.getIdentity()) || Objects.isNull(request.getApplicationName())) {
            return Message.build((boolean)false).setMessage("\u53c2\u6570\u7f3a\u5931");
        }
        List<String> platformListByBusinessType = PlatformEnum.getPlatformListByBusinessType(PlatformBusinessTypeEnum.PAYMENT);
        if (!platformListByBusinessType.contains(payPlatform)) {
            return Message.build((boolean)false).setMessage(payPlatform + "\u63d0\u73b0\u5e73\u53f0\u6682\u672a\u5b9e\u73b0");
        }
        if (Objects.equals(payPlatform, PlatformEnum.ALI.name()) && StringUtils.isBlank((CharSequence)request.getRealName())) {
            return Message.build((boolean)false).setMessage("\u652f\u4ed8\u5b9d\u63d0\u73b0\u9700\u8981\u6307\u5b9a\u8d26\u6237\u771f\u5b9e\u59d3\u540d");
        }
        if (Objects.equals(payPlatform, PlatformEnum.WX.name()) && StringUtils.isBlank((CharSequence)request.getAppId())) {
            return Message.build((boolean)false).setMessage("\u5fae\u4fe1\u63d0\u73b0\u9700\u8981\u6307\u5b9aappId");
        }
        context.setSync(Boolean.TRUE);
        return Message.build();
    }

    public void insertInfo(PlatformContext context) {
        WithdrawRequest request = (WithdrawRequest)context.getRequest();
        PaymentWithdrawFlowV2Entity paymentWithdrawFlowV2Entity = new PaymentWithdrawFlowV2Entity();
        paymentWithdrawFlowV2Entity.setId(this.sequenceCreater.nextLongId());
        paymentWithdrawFlowV2Entity.setPayPlatform(request.getPayPlatform());
        paymentWithdrawFlowV2Entity.setAccountId(request.getAccountId());
        paymentWithdrawFlowV2Entity.setIdentity(request.getIdentity());
        paymentWithdrawFlowV2Entity.setUserName(request.getRealName());
        paymentWithdrawFlowV2Entity.setAppId(request.getAppId());
        paymentWithdrawFlowV2Entity.setApplicationName(request.getApplicationName());
        paymentWithdrawFlowV2Entity.setWithdrawOrderNo(SequenceHolder.nextLongId());
        paymentWithdrawFlowV2Entity.setOutTrackNo(request.getOrderNo());
        paymentWithdrawFlowV2Entity.setStatus(Integer.valueOf(0));
        paymentWithdrawFlowV2Entity.setAmount(request.getAmount());
        paymentWithdrawFlowV2Entity.setCreateTime(new Date());
        paymentWithdrawFlowV2Entity.setRequestId(ThreadContext.getRequestId());
        this.withdrawFlowV2Mapper.insert((Object)paymentWithdrawFlowV2Entity);
        context.setOrderInfo(paymentWithdrawFlowV2Entity);
    }
}

