/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.callback;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.callback.IPlatformCallbackAction;
import com.bxm.thirdparty.platform.callback.context.PlatformCallbackContext;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.mapper.TrackLogMapper;
import com.bxm.thirdparty.platform.queue.QueueService;
import com.bxm.thirdparty.platform.queue.bo.QueueBO;
import com.bxm.thirdparty.platform.queue.bo.RequestBodyBO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PlatformCallbackManage {
    private static final Logger log = LoggerFactory.getLogger(PlatformCallbackManage.class);
    @Resource
    private TrackLogMapper trackLogMapper;
    @Resource
    private QueueService queueService;
    private Map<Class<?>, IPlatformCallbackAction> platformActionHashMap = new HashMap();

    public PlatformCallbackManage(List<IPlatformCallbackAction> iThirdPartyPlatformActions) {
        for (IPlatformCallbackAction iThirdPartyPlatformAction : iThirdPartyPlatformActions) {
            this.platformActionHashMap.put(this.buildKey(iThirdPartyPlatformAction), iThirdPartyPlatformAction);
        }
    }

    private Class<?> buildKey(PlatformCallbackContext context) {
        return context.getCallbackParam().getClass();
    }

    private Class<?> buildKey(IPlatformCallbackAction partyPlatformAction) {
        return partyPlatformAction.support();
    }

    public Message execCallback(PlatformCallbackContext context) {
        IPlatformCallbackAction iPlatformCallbackAction = this.platformActionHashMap.get(this.buildKey(context));
        if (Objects.isNull(iPlatformCallbackAction)) {
            return Message.build((boolean)false).setMessage("\u5e73\u53f0\u672a\u5b9e\u73b0\u7684\u63a5\u53e3");
        }
        Message message = iPlatformCallbackAction.execCallback(context);
        if (!message.isSuccess()) {
            return message;
        }
        String result = null;
        Object param = message.getParam(CommonConstant.RESULT_DTO);
        if (Objects.isNull(param)) {
            log.warn("\u56de\u8c03\u5904\u7406\u672a\u8fd4\u56de\u6709\u7528\u4fe1\u606f\uff0c\u8bf7\u53ca\u65f6\u5904\u7406:{}", (Object)context);
        } else {
            result = JSON.toJSONString((Object)param);
            QueueBO queueBO = new QueueBO();
            queueBO.setRequestId(ThreadContext.getRequestId());
            queueBO.setApplicationName(context.getApplicationName());
            queueBO.setRequestId(context.getRequestId());
            queueBO.setRequestBodyBO(RequestBodyBO.builder().type(context.getNotifyTypeEnum().name()).result(result).build());
            this.queueService.submitBusinessNotify(queueBO);
        }
        return Message.build();
    }
}

