/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.callback.refund;

import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.thirdparty.payment.facade.PaymentConfigFacadeService;
import com.bxm.thirdparty.platform.callback.IPlatformCallbackAction;
import com.bxm.thirdparty.platform.callback.context.PlatformCallbackContext;
import com.bxm.thirdparty.platform.callback.param.WxRefundCallbackParam;
import com.bxm.thirdparty.platform.constant.CommonConstant;
import com.bxm.thirdparty.platform.enums.PaymentRefundStatusEnum;
import com.bxm.thirdparty.platform.facade.notify.RefundNotifyResponse;
import com.bxm.thirdparty.platform.model.entity.PaymentRefundV2Entity;
import com.bxm.thirdparty.platform.service.PaymentService;
import com.github.binarywang.wxpay.bean.notify.WxPayRefundNotifyResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WxRefundCallbackAction
implements IPlatformCallbackAction {
    private static final Logger log = LoggerFactory.getLogger(WxRefundCallbackAction.class);
    @Resource
    private PaymentConfigFacadeService paymentConfigFacadeService;
    @Resource
    private PaymentService paymentService;

    @Override
    public Class<?> support() {
        return WxRefundCallbackParam.class;
    }

    @Override
    public Message execCallback(PlatformCallbackContext context) {
        WxRefundCallbackParam param = (WxRefundCallbackParam)context.getCallbackParam();
        PaymentRefundV2Entity refundV2Entity = (PaymentRefundV2Entity)context.getOrderInfo();
        if (!Objects.equals(refundV2Entity.getStatus(), PaymentRefundStatusEnum.REFUND_ING.getCode())) {
            log.warn("\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03\u8ba2\u5355\u72b6\u6001\uff1a{},\u5df2\u5904\u7406context:{}", (Object)refundV2Entity.getStatus(), (Object)context);
            return Message.build((boolean)false).setMessage("\u9000\u6b3e\u56de\u8c03\u5df2\u5904\u7406");
        }
        WxPayService wxPayService = this.paymentConfigFacadeService.getWxClientByMchId(param.getMchId());
        if (null == wxPayService) {
            log.error("\u652f\u4ed8\u914d\u7f6e\u4e0d\u5b58\u5728\u5546\u6237\u53f7\uff1a{}\uff0c\u9000\u6b3e\u4fe1\u606f\uff1a{}", (Object)param.getMchId(), (Object)param.getXmlData());
            return Message.build((boolean)false);
        }
        RefundNotifyResponse response = new RefundNotifyResponse();
        try {
            WxPayRefundNotifyResult result = wxPayService.parseRefundNotifyResult(param.getXmlData());
            if (StringUtils.equals((CharSequence)result.getReturnCode(), (CharSequence)"SUCCESS")) {
                response.setSuccess(Boolean.valueOf(true));
                this.paymentService.updateRefundOrderSuccess(refundV2Entity.getRefundOrderNo());
            } else {
                this.paymentService.updateRefundOrderFail(refundV2Entity.getRefundOrderNo(), result.getReturnMsg());
                response.setSuccess(Boolean.valueOf(false));
            }
            response.setErrorMsg(result.getReturnMsg());
        }
        catch (WxPayException e) {
            log.error("\u5fae\u4fe1\u56de\u8c03\u4fe1\u606f\u89e3\u6790\u5931\u8d25\uff1a{}", (Object)context, (Object)e);
            return Message.build((boolean)false).setMessage("\u5fae\u4fe1\u56de\u8c03\u4fe1\u606f\u89e3\u6790\u5931\u8d25");
        }
        response.setOutOrderNo(refundV2Entity.getOutOrderNo());
        response.setRefundOrderNo(refundV2Entity.getRefundOrderNo().toString());
        response.setPaymentOrderNo(refundV2Entity.getPaymentOrderNo().toString());
        return Message.build().addParam(CommonConstant.RESULT_DTO, (Object)response);
    }
}

