/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.context;

import java.util.HashMap;
import java.util.Map;

public class ThreadContext {
    private static final ThreadLocal<Map<String, String>> CTX_HOLDER = new ThreadLocal();
    public static final String REQUEST_ID_KEY = "requestIdKey";
    public static final String CLIENT_IP_KEY = "clientIp";

    public static final void init() {
        CTX_HOLDER.set(new HashMap());
    }

    public static final void putClientIp(String ip) {
        ThreadContext.putContext(CLIENT_IP_KEY, ip);
    }

    public static final void putRequestId(String traceId) {
        ThreadContext.putContext(REQUEST_ID_KEY, traceId);
    }

    public static final void clean() {
        CTX_HOLDER.remove();
    }

    public static final void putContext(String key, String value) {
        Map<String, String> ctx = CTX_HOLDER.get();
        if (ctx == null) {
            return;
        }
        ctx.put(key, value);
    }

    public static final String getRequestId() {
        return ThreadContext.getContext(REQUEST_ID_KEY);
    }

    public static final String getClientIp() {
        return ThreadContext.getContext(CLIENT_IP_KEY);
    }

    public static final String getContext(String key) {
        Map<String, String> ctx = CTX_HOLDER.get();
        if (ctx == null) {
            return null;
        }
        return ctx.get(key);
    }

    static {
        CTX_HOLDER.set(new HashMap());
    }
}

