/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.service.impl;

import com.bxm.thirdparty.platform.enums.PaymentOrderStatusEnum;
import com.bxm.thirdparty.platform.enums.PaymentRefundStatusEnum;
import com.bxm.thirdparty.platform.enums.PaymentWithdrawStatusEnum;
import com.bxm.thirdparty.platform.mapper.PaymentOrderV2Mapper;
import com.bxm.thirdparty.platform.mapper.PaymentRefundV2Mapper;
import com.bxm.thirdparty.platform.mapper.PaymentWithdrawFlowV2Mapper;
import com.bxm.thirdparty.platform.model.entity.PaymentOrderV2Entity;
import com.bxm.thirdparty.platform.model.entity.PaymentRefundV2Entity;
import com.bxm.thirdparty.platform.model.entity.PaymentWithdrawFlowV2Entity;
import com.bxm.thirdparty.platform.service.PaymentService;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentServiceImpl
implements PaymentService {
    private static final Logger log = LoggerFactory.getLogger(PaymentServiceImpl.class);
    private final PaymentRefundV2Mapper paymentRefundV2Mapper;
    private final PaymentOrderV2Mapper paymentOrderV2Mapper;
    private final PaymentWithdrawFlowV2Mapper paymentWithdrawFlowV2Mapper;

    @Override
    public void updateRefundOrderSuccess(Long refundOrderNo) {
        PaymentRefundV2Entity paymentRefundV2Entity = this.paymentRefundV2Mapper.getByRefundOrderNo(refundOrderNo);
        if (Objects.isNull(paymentRefundV2Entity)) {
            log.error("\u66f4\u65b0\u9000\u6b3e\u8ba2\u5355\u6210\u529f\uff0c\u4f46\u9000\u6b3e\u8ba2\u5355\u4e0d\u5b58\u5728\uff1a{}", (Object)refundOrderNo);
            return;
        }
        PaymentRefundV2Entity updateClass = new PaymentRefundV2Entity();
        updateClass.setId(paymentRefundV2Entity.getId());
        updateClass.setStatus(Integer.valueOf(PaymentRefundStatusEnum.REFUNDED.getCode()));
        updateClass.setRefundTime(new Date());
        updateClass.setModifyTime(new Date());
        this.paymentRefundV2Mapper.updateById((Object)updateClass);
        PaymentOrderV2Entity orderV2Entity = this.paymentOrderV2Mapper.getByOrderNo(paymentRefundV2Entity.getPaymentOrderNo());
        PaymentOrderV2Entity updateOrderClass = new PaymentOrderV2Entity();
        updateOrderClass.setId(paymentRefundV2Entity.getId());
        updateOrderClass.setStatus(Integer.valueOf(PaymentOrderStatusEnum.REFUNDED.getCode()));
        updateOrderClass.setModifyTime(new Date());
        this.paymentOrderV2Mapper.updateById((Object)orderV2Entity);
    }

    @Override
    public void updateRefundOrderRefundIng(Long refundOrderNo) {
        PaymentRefundV2Entity paymentRefundV2Entity = this.paymentRefundV2Mapper.getByRefundOrderNo(refundOrderNo);
        if (Objects.isNull(paymentRefundV2Entity)) {
            log.error("\u66f4\u65b0\u9000\u6b3e\u8ba2\u5355\u6210\u529f\uff0c\u4f46\u9000\u6b3e\u8ba2\u5355\u4e0d\u5b58\u5728\uff1a{}", (Object)refundOrderNo);
            return;
        }
        PaymentOrderV2Entity orderV2Entity = this.paymentOrderV2Mapper.getByOrderNo(paymentRefundV2Entity.getPaymentOrderNo());
        PaymentOrderV2Entity updateOrderClass = new PaymentOrderV2Entity();
        updateOrderClass.setId(paymentRefundV2Entity.getId());
        updateOrderClass.setStatus(Integer.valueOf(PaymentOrderStatusEnum.REFUND_ING.getCode()));
        updateOrderClass.setModifyTime(new Date());
        this.paymentOrderV2Mapper.updateById((Object)orderV2Entity);
    }

    @Override
    public void updateRefundOrderFail(Long refundOrderNo, String errorMsg) {
        PaymentRefundV2Entity paymentRefundV2Entity = this.paymentRefundV2Mapper.getByRefundOrderNo(refundOrderNo);
        if (Objects.isNull(paymentRefundV2Entity)) {
            log.error("\u66f4\u65b0\u9000\u6b3e\u8ba2\u5355\u6210\u529f\uff0c\u4f46\u9000\u6b3e\u8ba2\u5355\u4e0d\u5b58\u5728\uff1a{}", (Object)refundOrderNo);
            return;
        }
        PaymentRefundV2Entity updateClass = new PaymentRefundV2Entity();
        updateClass.setId(paymentRefundV2Entity.getId());
        updateClass.setStatus(Integer.valueOf(PaymentRefundStatusEnum.REFUND_FAIL.getCode()));
        updateClass.setRefundTime(new Date());
        updateClass.setModifyTime(new Date());
        updateClass.setRemark(errorMsg);
        this.paymentRefundV2Mapper.updateById((Object)updateClass);
        PaymentOrderV2Entity orderV2Entity = this.paymentOrderV2Mapper.getByOrderNo(paymentRefundV2Entity.getPaymentOrderNo());
        PaymentOrderV2Entity updateOrderClass = new PaymentOrderV2Entity();
        updateOrderClass.setId(paymentRefundV2Entity.getId());
        updateOrderClass.setStatus(Integer.valueOf(PaymentOrderStatusEnum.REFUND_FAIL.getCode()));
        updateOrderClass.setModifyTime(new Date());
        this.paymentOrderV2Mapper.updateById((Object)orderV2Entity);
    }

    @Override
    public void updateWithdrawOrderSuccess(Long orderNo) {
        PaymentWithdrawFlowV2Entity paymentWithdrawFlowV2Entity = this.paymentWithdrawFlowV2Mapper.getByWithdrawOrderNo(orderNo);
        if (Objects.isNull(paymentWithdrawFlowV2Entity)) {
            log.error("\u66f4\u65b0\u63d0\u73b0\u8ba2\u5355\u6210\u529f\uff0c\u4f46\u63d0\u73b0\u8ba2\u5355\u4e0d\u5b58\u5728\uff1a{}", (Object)orderNo);
            return;
        }
        PaymentWithdrawFlowV2Entity updateOrderClass = new PaymentWithdrawFlowV2Entity();
        updateOrderClass.setId(paymentWithdrawFlowV2Entity.getId());
        updateOrderClass.setStatus(Integer.valueOf(PaymentWithdrawStatusEnum.SUCCEED.getCode()));
        updateOrderClass.setModifyTime(new Date());
        updateOrderClass.setWithdrawTime(new Date());
        this.paymentWithdrawFlowV2Mapper.updateById((Object)updateOrderClass);
    }

    @Override
    public void updateWithdrawOrderFail(Long orderNo, String errorMsg) {
        PaymentWithdrawFlowV2Entity paymentWithdrawFlowV2Entity = this.paymentWithdrawFlowV2Mapper.getByWithdrawOrderNo(orderNo);
        if (Objects.isNull(paymentWithdrawFlowV2Entity)) {
            log.error("\u66f4\u65b0\u63d0\u73b0\u8ba2\u5355\u5931\u8d25\uff0c\u4f46\u63d0\u73b0\u8ba2\u5355\u4e0d\u5b58\u5728\uff1a{},error:{}", (Object)orderNo, (Object)errorMsg);
            return;
        }
        PaymentWithdrawFlowV2Entity updateOrderClass = new PaymentWithdrawFlowV2Entity();
        updateOrderClass.setId(paymentWithdrawFlowV2Entity.getId());
        updateOrderClass.setStatus(Integer.valueOf(PaymentWithdrawStatusEnum.FAILED.getCode()));
        updateOrderClass.setModifyTime(new Date());
        updateOrderClass.setWithdrawTime(new Date());
        updateOrderClass.setErrorMsg(errorMsg);
        this.paymentWithdrawFlowV2Mapper.updateById((Object)updateOrderClass);
    }

    public PaymentServiceImpl(PaymentRefundV2Mapper paymentRefundV2Mapper, PaymentOrderV2Mapper paymentOrderV2Mapper, PaymentWithdrawFlowV2Mapper paymentWithdrawFlowV2Mapper) {
        this.paymentRefundV2Mapper = paymentRefundV2Mapper;
        this.paymentOrderV2Mapper = paymentOrderV2Mapper;
        this.paymentWithdrawFlowV2Mapper = paymentWithdrawFlowV2Mapper;
    }
}

