/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.service.impl;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.platform.callback.PlatformCallbackManage;
import com.bxm.thirdparty.platform.callback.context.PlatformCallbackContext;
import com.bxm.thirdparty.platform.callback.param.AlipayPaymentCallbackParam;
import com.bxm.thirdparty.platform.callback.param.LiBaCallbackParam;
import com.bxm.thirdparty.platform.callback.param.WxPaymentCallbackParam;
import com.bxm.thirdparty.platform.callback.param.WxRefundCallbackParam;
import com.bxm.thirdparty.platform.callback.param.XinRongChargePhoneParam;
import com.bxm.thirdparty.platform.facade.enums.NotifyTypeEnum;
import com.bxm.thirdparty.platform.mapper.ChargesPhoneLogMapper;
import com.bxm.thirdparty.platform.mapper.ElectricLogMapper;
import com.bxm.thirdparty.platform.mapper.PaymentOrderV2Mapper;
import com.bxm.thirdparty.platform.mapper.PaymentRefundV2Mapper;
import com.bxm.thirdparty.platform.model.entity.ChargesPhoneLogEntity;
import com.bxm.thirdparty.platform.model.entity.ElectricLogEntity;
import com.bxm.thirdparty.platform.model.entity.PaymentOrderV2Entity;
import com.bxm.thirdparty.platform.model.entity.PaymentRefundV2Entity;
import com.bxm.thirdparty.platform.service.ThirdPartyCallbackService;
import com.bxm.thirdparty.platform.utils.TraceUtil;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ThirdPartyCallbackServiceImpl
implements ThirdPartyCallbackService {
    private static final Logger log = LoggerFactory.getLogger(ThirdPartyCallbackServiceImpl.class);
    private final PlatformCallbackManage platformCallbackManage;
    private final PaymentOrderV2Mapper paymentOrderV2Mapper;
    private final PaymentRefundV2Mapper paymentRefundV2Mapper;
    private final ElectricLogMapper electricLogMapper;
    private final ChargesPhoneLogMapper chargesPhoneLogMapper;

    @Override
    public Message execAlipayTradeCallback(AlipayPaymentCallbackParam param) {
        PaymentOrderV2Entity paymentOrderV2Entity = this.paymentOrderV2Mapper.getByOrderNo(Long.valueOf(Long.parseLong(param.getOutTradeNo())));
        if (Objects.isNull(paymentOrderV2Entity)) {
            return Message.build((boolean)false).setMessage("\u652f\u4ed8\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        TraceUtil.replaceRequestId(paymentOrderV2Entity.getRequestId());
        log.info("\u91cd\u7f6erequestId\uff0c\u652f\u4ed8\u5b9d\u56de\u8c03\u53c2\u6570: {},", (Object)param);
        PlatformCallbackContext<AlipayPaymentCallbackParam, PaymentOrderV2Entity> context = new PlatformCallbackContext<AlipayPaymentCallbackParam, PaymentOrderV2Entity>();
        context.setCallbackParam(param);
        context.setOrderInfo(paymentOrderV2Entity);
        context.setNotifyTypeEnum(NotifyTypeEnum.PAYMENT);
        context.setApplicationName(paymentOrderV2Entity.getApplicationName());
        context.setRequestId(paymentOrderV2Entity.getRequestId());
        return this.platformCallbackManage.execCallback(context);
    }

    @Override
    public Message executeWechatCallback(WxPaymentCallbackParam param) {
        PaymentOrderV2Entity paymentOrderV2Entity = this.paymentOrderV2Mapper.getByOrderNo(Long.valueOf(Long.parseLong(param.getPaymentOrderNo())));
        if (Objects.isNull(paymentOrderV2Entity)) {
            return Message.build((boolean)false).setMessage("\u652f\u4ed8\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        TraceUtil.replaceRequestId(paymentOrderV2Entity.getRequestId());
        log.info("\u91cd\u7f6erequestId\uff0c\u5fae\u4fe1\u56de\u8c03\u53c2\u6570: {},", (Object)param);
        PlatformCallbackContext<WxPaymentCallbackParam, PaymentOrderV2Entity> context = new PlatformCallbackContext<WxPaymentCallbackParam, PaymentOrderV2Entity>();
        context.setCallbackParam(param);
        context.setOrderInfo(paymentOrderV2Entity);
        context.setNotifyTypeEnum(NotifyTypeEnum.PAYMENT);
        context.setApplicationName(paymentOrderV2Entity.getApplicationName());
        context.setRequestId(paymentOrderV2Entity.getRequestId());
        return this.platformCallbackManage.execCallback(context);
    }

    @Override
    public Message execXinrongCallback(XinRongChargePhoneParam param) {
        ChargesPhoneLogEntity chargesPhoneLogEntity = this.chargesPhoneLogMapper.getByOrderNo(Long.valueOf(Long.parseLong(param.getOut_logno())));
        if (Objects.isNull(chargesPhoneLogEntity)) {
            return Message.build((boolean)false).setMessage("\u8bdd\u8d39\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        TraceUtil.replaceRequestId(chargesPhoneLogEntity.getRequestId());
        log.info("\u91cd\u7f6erequestId\uff0c\u5fc3\u878d\u56de\u8c03\u53c2\u6570: {},", (Object)param);
        PlatformCallbackContext<XinRongChargePhoneParam, ChargesPhoneLogEntity> context = new PlatformCallbackContext<XinRongChargePhoneParam, ChargesPhoneLogEntity>();
        context.setCallbackParam(param);
        context.setOrderInfo(chargesPhoneLogEntity);
        context.setNotifyTypeEnum(NotifyTypeEnum.CHARGE_PHONE);
        context.setApplicationName(chargesPhoneLogEntity.getApplicationName());
        context.setRequestId(chargesPhoneLogEntity.getRequestId());
        return this.platformCallbackManage.execCallback(context);
    }

    @Override
    public Message execLiBaCallback(LiBaCallbackParam param) {
        ElectricLogEntity electricLogEntity = this.electricLogMapper.getByOrderNo(Long.valueOf(Long.parseLong(param.getOrderId())));
        if (Objects.isNull(electricLogEntity)) {
            return Message.build((boolean)false).setMessage("\u7535\u8d39\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        TraceUtil.replaceRequestId(electricLogEntity.getRequestId());
        log.info("\u91cd\u7f6erequestId\uff0c\u529b\u62d4\u56de\u8c03\u53c2\u6570: {},", (Object)param);
        PlatformCallbackContext<LiBaCallbackParam, ElectricLogEntity> context = new PlatformCallbackContext<LiBaCallbackParam, ElectricLogEntity>();
        context.setCallbackParam(param);
        context.setOrderInfo(electricLogEntity);
        context.setNotifyTypeEnum(NotifyTypeEnum.ELECTRIC);
        context.setApplicationName(electricLogEntity.getApplicationName());
        context.setRequestId(electricLogEntity.getRequestId());
        return this.platformCallbackManage.execCallback(context);
    }

    @Override
    public Message execWechatRefund(WxRefundCallbackParam param) {
        PaymentRefundV2Entity orderInfo = this.paymentRefundV2Mapper.getByRefundOrderNo(Long.valueOf(Long.parseLong(param.getRefundOrderNo())));
        if (Objects.isNull(orderInfo)) {
            return Message.build((boolean)false).setMessage("\u9000\u6b3e\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        TraceUtil.replaceRequestId(orderInfo.getRequestId());
        log.info("\u91cd\u7f6erequestId\uff0c\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03\u53c2\u6570: {},", (Object)param);
        PlatformCallbackContext<WxRefundCallbackParam, PaymentRefundV2Entity> context = new PlatformCallbackContext<WxRefundCallbackParam, PaymentRefundV2Entity>();
        context.setCallbackParam(param);
        context.setOrderInfo(orderInfo);
        context.setNotifyTypeEnum(NotifyTypeEnum.REFUND);
        context.setApplicationName(orderInfo.getApplicationName());
        context.setRequestId(orderInfo.getRequestId());
        return this.platformCallbackManage.execCallback(context);
    }

    public ThirdPartyCallbackServiceImpl(PlatformCallbackManage platformCallbackManage, PaymentOrderV2Mapper paymentOrderV2Mapper, PaymentRefundV2Mapper paymentRefundV2Mapper, ElectricLogMapper electricLogMapper, ChargesPhoneLogMapper chargesPhoneLogMapper) {
        this.platformCallbackManage = platformCallbackManage;
        this.paymentOrderV2Mapper = paymentOrderV2Mapper;
        this.paymentRefundV2Mapper = paymentRefundV2Mapper;
        this.electricLogMapper = electricLogMapper;
        this.chargesPhoneLogMapper = chargesPhoneLogMapper;
    }
}

