/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.platform.service.impl;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.thirdparty.platform.adapter.ThirdPartyPlatformManage;
import com.bxm.thirdparty.platform.adapter.context.PlatformContext;
import com.bxm.thirdparty.platform.before.BeforeThirdPartyPlatformManage;
import com.bxm.thirdparty.platform.context.ThreadContext;
import com.bxm.thirdparty.platform.facade.request.BaseRequest;
import com.bxm.thirdparty.platform.service.ApplicationRelationService;
import com.bxm.thirdparty.platform.service.ThirdPartyPlatformService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ThirdPartyPlatformServiceImpl<O>
implements ThirdPartyPlatformService {
    private static final Logger log = LoggerFactory.getLogger(ThirdPartyPlatformServiceImpl.class);
    private final ThirdPartyPlatformManage thirdPartyPlatformManage;
    private final BeforeThirdPartyPlatformManage beforeThirdPartyPlatformManage;
    private final ApplicationRelationService applicationRelationService;
    private final DistributedLock distributedLock;

    @Override
    public <T extends BaseRequest> Message execPlatformHandler(T t) {
        int i = JSON.toJSONString(t).hashCode();
        boolean lock = this.distributedLock.lock(t.getApplicationName() + i);
        if (!lock) {
            log.warn("\u8bf7\u52ff\u91cd\u590d\u70b9\u51fb\uff1a{}", t);
            return Message.build((boolean)false).setMessage("\u8bf7\u52ff\u91cd\u590d\u70b9\u51fb");
        }
        String notifyUrl = this.applicationRelationService.getNotifyUrl(t.getApplicationName());
        if (Objects.isNull(notifyUrl)) {
            return Message.build((boolean)false).setMessage("\u4e1a\u52a1\u672a\u6ce8\u518c\u5230\u5185\u90e8\u5c01\u88c5\u670d\u52a1");
        }
        PlatformContext context = new PlatformContext();
        context.setRequest(t);
        context.setNotifyUrl(notifyUrl);
        context.setRequestId(ThreadContext.getRequestId());
        Message exec = this.beforeThirdPartyPlatformManage.execBefore(context);
        if (!exec.isSuccess()) {
            return exec;
        }
        return this.thirdPartyPlatformManage.execCore(context);
    }

    public ThirdPartyPlatformServiceImpl(ThirdPartyPlatformManage thirdPartyPlatformManage, BeforeThirdPartyPlatformManage beforeThirdPartyPlatformManage, ApplicationRelationService applicationRelationService, DistributedLock distributedLock) {
        this.thirdPartyPlatformManage = thirdPartyPlatformManage;
        this.beforeThirdPartyPlatformManage = beforeThirdPartyPlatformManage;
        this.applicationRelationService = applicationRelationService;
        this.distributedLock = distributedLock;
    }
}

