package com.bxm.kylin.checker.checker;

import com.bxm.kylin.core.entity.BlacklistType;
import com.bxm.kylin.core.entity.CheckPlan;
import com.bxm.kylin.core.entity.Domain;
import org.apache.commons.lang.StringUtils;

/**
 * 监测器
 * @author allen
 * @date 2019/10/16
 * @since 1.0.0
 */
public interface Checker {

    CheckEnvironmentEnum getCheckEnvironment();

    Checked check(CheckPlan plan, Domain domain);

    /**
     * 返回这个探测是否全局黑名单。
     * @return 如果是
     */
    default boolean isGlobalBlacklist() {
        return false;
    }

    /**
     * 获取这个探测器的特征串
     *
     * @return 特征串。如：MicroMessenger
     */
    default String getBlacklistFeature() {
        return null;
    }

    /**
     * 返回这个探测器的黑名单类型。
     * @return 黑名单类型
     */
    default BlacklistType getBlacklistType() {
        return BlacklistType.Browser;
    };

    default CheckResult checkMicroMessenger(String body, String expectBody){
        if (StringUtils.isNotEmpty(body) || StringUtils.isNotEmpty(expectBody)) {
            if (StringUtils.contains(body, expectBody)) {
                return CheckResult.NOPASS;
            } else {
                return CheckResult.PASSED;
            }
        } else {
            return CheckResult.NOPASS;
        }
    }
}
