package com.bxm.kylin.checker.checker;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bxm.kylin.checker.job.scheduler.JobScheduler;
import com.bxm.kylin.core.entity.CheckPlan;
import com.bxm.kylin.core.entity.CheckPlanConst;
import com.bxm.kylin.core.service.ICheckPlanService;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;

import java.util.List;

/**
 * 监测器总控
 * @author allen
 * @date 2019/10/16
 * @since 1.0.0
 */
@Configuration
public class CheckerJobControl implements ApplicationListener<ApplicationReadyEvent> {

    private final JobScheduler scheduler;
    private final ICheckPlanService checkPlanService;

    public CheckerJobControl(JobScheduler scheduler, ICheckPlanService checkPlanService) {
        this.scheduler = scheduler;
        this.checkPlanService = checkPlanService;
    }

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.triggerJobs();
    }

    private void triggerJobs() {
        CheckPlan query = new CheckPlan();
        query.setStatus(CheckPlanConst.STATUS_ENABLED);
        List<CheckPlan> list = checkPlanService.list(Wrappers.query(query));
        for (CheckPlan checkPlan : list) {
            scheduler.trigger(checkPlan);
        }
    }
}
