package com.bxm.kylin.checker.checker.impl;

import com.bxm.kylin.checker.checker.CheckEnvironmentEnum;
import com.bxm.kylin.checker.checker.CheckResult;
import com.bxm.kylin.checker.checker.Checked;
import com.bxm.kylin.checker.checker.Checker;
import com.bxm.kylin.core.entity.BlacklistType;
import com.bxm.kylin.core.entity.CheckPlan;
import com.bxm.kylin.core.entity.Domain;
import com.bxm.kylin.core.service.WeChatService;
import com.bxm.kylin.utils.DomainUtils;
import com.bxm.kylin.utils.RestUtils;
import com.bxm.kylin.utils.StringHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/**
 * 微信监测器
 *
 * @author allen
 * @date 2019/10/16
 * @since 1.0.0
 */
@Slf4j
@Configuration
public class MicroMessengerChecker implements Checker {

    private WeChatService weChatService;
    private final RestTemplate restTemplate = new RestTemplateBuilder().build();

    public MicroMessengerChecker(WeChatService weChatService) {
        this.weChatService = weChatService;
    }

    @Override
    public CheckEnvironmentEnum getCheckEnvironment() {
        return CheckEnvironmentEnum.MicroMessenger;
    }

    @Override
    public Checked check(CheckPlan plan, Domain domain) {
        String cookie = weChatService.getTicket().getCookie();
        String url = DomainUtils.getWholeUrl(domain);
        url = StringHelper.urlDecode(url);
        Checked checked = new Checked();
        checked.setCheckUrl(new String(url));
        if (StringUtils.isBlank(cookie)) {
            checked.setCheckResult(CheckResult.NOPASS);
            return checked;
        }

        MultiValueMap<String, String> headers = new LinkedMultiValueMap<>();
        headers.add("Cookie", cookie);
        // https://wx2.qq.com/cgi-bin/mmwebwx-bin/webwxcheckurl?requrl=http%3A%2F%2Factivity.cat-lottery.cn%2F&skey=%40crypt_a27d259a_a6ceed7f24ae7c5885b91511f33820af&deviceid=e001554664038704&pass_ticket=undefined&opcode=2&scene=1&username=@028ff4d879a11db2673422a580bd51fee3f383ed51eefaf567debc6083f0ca04
        url = "https://wx2.qq.com/cgi-bin/mmwebwx-bin/webwxcheckurl?requrl=" + url;
        ResponseEntity<String> responseEntity = RestUtils.get(restTemplate, url, headers);
        int code = responseEntity.getStatusCodeValue();
        String html = responseEntity.getBody();
        if (log.isDebugEnabled()) {
            log.debug("Wechat result html {}", html);
        }
        CheckResult result = checkMicroMessenger(html, plan.getExpectBodyRegex());
        if (log.isDebugEnabled()) {
            log.debug("Url checking result is {} of {}", result, url);
        }
        checked.setCheckResult(result);
        checked.setBody(html);
        checked.setStatusCode(code);
        return checked;
    }

    @Override
    public String getBlacklistFeature() {
        return "MicroMessenger";
    }

    @Override
    public BlacklistType getBlacklistType() {
        return BlacklistType.Browser;
    }
}
