package com.bxm.kylin.checker.job;


import com.bxm.kylin.checker.checker.Checked;
import com.bxm.kylin.checker.checker.Checker;
import com.bxm.kylin.core.entity.CheckEnvironment;
import com.bxm.kylin.core.entity.CheckPlan;
import com.bxm.kylin.core.entity.Domain;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.context.ApplicationContext;

/**
 * @author allen
 * @since 1.0.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MyJob extends CheckPlan {

    private ApplicationContext applicationContext;
    private Checker checker;
    private CheckEnvironment checkEnvironment;
    private Domain domain;
    private Checked checked;

    public MyJob(CheckPlan checkPlan, ApplicationContext applicationContext) {
        setId(checkPlan.getId());
        setCreateTime(checkPlan.getCreateTime());
        setCronExpression(checkPlan.getCronExpression());
        setDomainId(checkPlan.getDomainId());
        setEnvironmentId(checkPlan.getEnvironmentId());
        setExpectBodyRegex(checkPlan.getExpectBodyRegex());
        setExpectStatusCode(checkPlan.getExpectStatusCode());
        setModifyTime(checkPlan.getModifyTime());
        setStatus(checkPlan.getStatus());
        this.applicationContext = applicationContext;
    }

    public String getJobName() {
        return "JOB-" + super.getId();
    }

    public String getJobGroup() {
        return "DEFAULT";
    }

    public String getCronExpress() {
        return super.getCronExpression();
    }
}
