package com.bxm.kylin.checker.job.scheduler;


import com.bxm.kylin.checker.job.MyJob;
import com.bxm.kylin.core.entity.CheckPlan;

/**
 * @author allen
 * @since 1.0.0
 */
public interface JobScheduler {

    /**
     * 触发一个计划任务
     * @param checkPlan 计划
     * @return 触发成功或失败
     */
    boolean trigger(CheckPlan checkPlan);

    /**
     * 删除一个计划任务
     * @param checkPlan 计划
     * @return 删除成功或失败
     */
    boolean remove(CheckPlan checkPlan);

    /**
     * 触发一个任务
     *
     * @param job 任务
     * @return 触发成功
     */
    @Deprecated
    boolean triggerJob(MyJob job);

    /**
     * 禁用一个任务
     *
     * @param job 任务
     * @return 禁用成功
     */
    @Deprecated
    boolean removeJob(MyJob job);
}
