package com.bxm.kylin.checker.job.worker;

import com.bxm.kylin.checker.checker.Checked;
import com.bxm.kylin.checker.checker.Checker;
import com.bxm.kylin.checker.job.JobConstant;
import com.bxm.kylin.checker.job.MyJob;
import com.bxm.kylin.core.entity.Domain;
import com.bxm.kylin.core.service.ICheckEnvironmentService;
import com.bxm.kylin.core.service.IDomainService;
import lombok.extern.slf4j.Slf4j;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

/**
 * @author allen
 * @since 1.0.0
 */
@Slf4j
public class JobWorkerDispatcher implements org.quartz.Job {

    private static final Logger LOGGER = LoggerFactory.getLogger(JobWorkerDispatcher.class);

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDetail jobDetail = jobExecutionContext.getJobDetail();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        Object jobValue = jobDataMap.get(JobConstant.JobDataMapField.JOB);
        if (!(jobValue instanceof MyJob)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Could not found value at jobDataMap [{}]", JobConstant.JobDataMapField.JOB);
            }
            return;
        }
        MyJob job = (MyJob) jobValue;

        this.fillEntity(job);
        Checker checker = job.getChecker();
        Domain domain = job.getDomain();
        if (null == checker || null == domain) {
            log.warn("Illegal job: {}", job);
            return;
        }
        Checked result = checker.check(job, domain);
        jobDataMap.put(JobConstant.JobDataMapField.RESULT, result.getCheckResult());

        job.setChecked(result);
    }

    private void fillEntity(MyJob job) {
        ApplicationContext applicationContext = job.getApplicationContext();
        IDomainService domainService = applicationContext.getBean(IDomainService.class);
        ICheckEnvironmentService checkEnvironmentService = applicationContext.getBean(ICheckEnvironmentService.class);
        job.setDomain(domainService.getById(job.getDomainId()));
        job.setCheckEnvironment(checkEnvironmentService.getById(job.getEnvironmentId()));
    }
}
