package com.bxm.kylin.checker.listener;

import com.bxm.kylin.Constants;
import com.bxm.kylin.checker.job.scheduler.JobScheduler;
import com.bxm.kylin.core.entity.CheckPlan;
import com.bxm.kylin.core.entity.CheckPlanConst;
import com.bxm.warcar.mq.ConsumeStatus;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.autoconfigure.Subscriber;
import com.bxm.warcar.mq.autoconfigure.SubscriberWrapper;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

/**
 * @author allen
 * @date 2019/10/21
 * @since 1.0.0
 */
@Slf4j
@Subscriber
public class CheckPlanUpdatingListener implements SingleMessageListener, SubscriberWrapper {

    private final JobScheduler jobScheduler;

    public CheckPlanUpdatingListener(JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
    }

    @Override
    public ConsumeStatus consume(Message message, Object context) {
        String tags = message.getTags();
        byte[] body = message.getBody();
        CheckPlan checkPlan = JsonHelper.convert(body, CheckPlan.class);

        if (StringUtils.equals(Constants.MessageQueue.Tag.DELETE, tags)) {
            // delete job
            jobScheduler.remove(checkPlan);
        }
        if (StringUtils.equals(Constants.MessageQueue.Tag.UPDATE, tags)) {
            // update job
            jobScheduler.remove(checkPlan);
            if (checkPlan.getStatus() == CheckPlanConst.STATUS_ENABLED) {
                jobScheduler.trigger(checkPlan);
            }
        }
        if (log.isInfoEnabled()) {
            log.info("[{}] Check plan has been updated.", checkPlan.getId());
        }

        return ConsumeStatus.CONSUME_SUCCESS;
    }

    @Override
    public String getTopic() {
        return CheckPlan.class.getName();
    }

    @Override
    public String getConsumerId() {
        return getClass().getName();
    }
}
