package com.bxm.kylin.checker.trigger;

import com.bxm.kylin.checker.checker.CheckResult;
import com.bxm.kylin.checker.job.JobConstant;
import com.bxm.kylin.checker.job.MyJob;
import org.quartz.*;

/**
 * @author allen
 * @date 2019/10/16
 * @since 1.0.0
 */
public abstract class AbstractTrigger implements JobListener, Trigger {

    /**
     * <p>处理结果，不论通过还是不通过都会执行。</p>
     * 如果实现了{@link #doNoPass(MyJob)} 或者{@link #doPassed(MyJob)}抽象方法，那么也会执行。
     * @param job 任务
     * @param result 监测结果
     */
    protected abstract void handle(MyJob job, CheckResult result);

    /**
     * <p>处理通过的结果</p>
     * 如果实现了{@link #handle(MyJob, CheckResult)}，那么也会执行。
     * @param job 任务
     */
    protected abstract void doPassed(MyJob job);

    /**
     * <p>处理不通过的结果</p>
     * 如果实现了{@link #handle(MyJob, CheckResult)}，那么也会执行。
     * @param job 任务
     */
    protected abstract void doNoPass(MyJob job);

    @Override
    public String getName() {
        return getClass().getSimpleName();
    }

    @Override
    public void jobToBeExecuted(JobExecutionContext jobExecutionContext) {

    }

    @Override
    public void jobExecutionVetoed(JobExecutionContext jobExecutionContext) {

    }

    @Override
    public void jobWasExecuted(JobExecutionContext jobExecutionContext, JobExecutionException e) {
        JobDetail jobDetail = jobExecutionContext.getJobDetail();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();

        MyJob myJob = (MyJob) jobDataMap.get(JobConstant.JobDataMapField.JOB);
        CheckResult result = (CheckResult) jobDataMap.get(JobConstant.JobDataMapField.RESULT);

        this.handle(myJob, result);

        if (result == CheckResult.PASSED) {
            this.doPassed(myJob);
        }
        if (result == CheckResult.NOPASS) {
            this.doNoPass(myJob);
        }
    }
}
