package com.bxm.kylin.checker.trigger;

import com.bxm.kylin.checker.checker.CheckResult;
import com.bxm.kylin.checker.checker.Checked;
import com.bxm.kylin.checker.job.MyJob;
import com.bxm.kylin.utils.DomainUtils;
import com.bxm.kylin.core.entity.CheckLog;
import com.bxm.kylin.core.service.ICheckLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import java.time.LocalDateTime;

/**
 * @author allen
 * @date 2019/10/16
 * @since 1.0.0
 */
@Slf4j
@Configuration
public class LoggingTrigger extends AbstractTrigger {

    private final ICheckLogService checkLogService;

    public LoggingTrigger(ICheckLogService checkLogService) {
        this.checkLogService = checkLogService;
    }

    @Override
    protected void handle(MyJob job, CheckResult result) {
        String fullName = job.getJobName();
        if (log.isDebugEnabled()) {
            log.debug("[{}] executed job: {}", fullName, job);
            log.debug("[{}] return: {}", fullName, result);
        }
        Checked checked = job.getChecked();
        if (null == checked) {
            return;
        }

        CheckLog checkLog = new CheckLog();
        checkLog.setBody(checked.getBody());
        checkLog.setCheckTime(LocalDateTime.now());
        checkLog.setCheckUrl(DomainUtils.getWholeUrl(job.getDomain()));
        checkLog.setDomain(job.getDomain().getDomain());
        checkLog.setEnvironment(job.getCheckEnvironment().getEnvironment());
        checkLog.setHeaders(checked.getHeaders());
        checkLog.setPassed(result.getValue());
        checkLog.setPlanId(job.getId());
        checkLog.setStatusCode(checked.getStatusCode());

        checkLogService.save(checkLog);
    }

    @Override
    protected void doPassed(MyJob job) {

    }

    @Override
    protected void doNoPass(MyJob job) {

    }
}
