package com.bxm.kylin.checker.trigger;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bxm.kylin.checker.checker.CheckResult;
import com.bxm.kylin.checker.checker.Checker;
import com.bxm.kylin.checker.job.MyJob;
import com.bxm.kylin.core.entity.Blacklist;
import com.bxm.kylin.core.entity.BlacklistConst;
import com.bxm.kylin.core.service.IBlacklistService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;
import org.springframework.dao.DuplicateKeyException;

/**
 * 提交到黑名单列表的触发器
 * @author allen
 * @date 2019/10/16
 * @since 1.0.0
 */
@Configuration
@Slf4j
public class PostBlacklistTrigger extends AbstractTrigger {

    private final IBlacklistService blacklistService;

    public PostBlacklistTrigger(IBlacklistService blacklistService) {
        this.blacklistService = blacklistService;
    }

    @Override
    protected void handle(MyJob job, CheckResult result) {
    }

    @Override
    protected void doPassed(MyJob job) {
        Blacklist blacklist = getBlacklist(job);
        if (blacklist == null) {
            return;
        }

        blacklistService.remove(Wrappers.query(blacklist));
    }

    @Override
    protected void doNoPass(MyJob job) {
        Blacklist blacklist = getBlacklist(job);
        if (blacklist == null) {
            return;
        }
        try {
            blacklistService.save(blacklist);
        } catch (DuplicateKeyException e) {
            if (log.isDebugEnabled()) {
                log.debug("blacklist already exist");
            }
        }
    }

    private Blacklist getBlacklist(MyJob job) {
        Checker checker = job.getChecker();
        String feature = checker.getBlacklistFeature();

        if (checker.isGlobalBlacklist()) {
            return null;
        }
        Blacklist blacklist = new Blacklist();
        blacklist.setAuthor(BlacklistConst.AUTHOR_SYSTEM);
        blacklist.setDomainId(job.getDomainId());
        blacklist.setFeature(feature);
        blacklist.setType(checker.getBlacklistType().value());
        return blacklist;
    }
}
