package com.bxm.kylin.checker.trigger;

import com.bxm.kylin.checker.checker.CheckResult;
import com.bxm.kylin.checker.checker.Checker;
import com.bxm.kylin.checker.job.MyJob;
import com.bxm.kylin.core.entity.Domain;
import com.bxm.kylin.core.entity.DomainConst;
import com.bxm.kylin.core.service.IDomainService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Configuration;

import java.time.LocalDateTime;

/**
 * 更新域名状态触发器
 *
 * @author allen
 * @date 2019/10/16
 * @since 1.0.0
 */
@Slf4j
@Configuration
public class UpdateDomainStatusTrigger extends AbstractTrigger {

    private final IDomainService domainService;

    public UpdateDomainStatusTrigger(IDomainService domainService) {
        this.domainService = domainService;
    }

    @Override
    protected void handle(MyJob job, CheckResult result) {
    }

    @Override
    protected void doPassed(MyJob job) {
        this.handle(job, DomainConst.STATUS_ENABLED);
    }

    @Override
    protected void doNoPass(MyJob job) {
        this.handle(job, DomainConst.STATUS_DISABLED);
    }

    private void handle(MyJob job, int status) {
        Checker checker = job.getChecker();
        if (!checker.isGlobalBlacklist()) {
            return;
        }
        Domain domain = job.getDomain();
        if (domain.getStatus() == status) {
            return;
        }
        domain.setStatus(status);
        domain.setModifyTime(LocalDateTime.now());
        if (!domainService.updateById(domain)) {
            log.warn("[{}] Domain update fail!", domain.getId());
        }
    }
}
