/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.checker.checker.impl;

import com.bxm.kylin.checker.checker.CheckEnvironmentEnum;
import com.bxm.kylin.checker.checker.CheckResult;
import com.bxm.kylin.checker.checker.Checked;
import com.bxm.kylin.checker.checker.impl.AbstractChecker;
import com.bxm.kylin.core.entity.CheckPlan;
import com.bxm.kylin.core.entity.Domain;
import com.bxm.kylin.utils.DomainUtils;
import com.bxm.warcar.utils.JsonHelper;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Configuration
public class HttpChecker
extends AbstractChecker {
    private static final Logger log = LoggerFactory.getLogger(HttpChecker.class);
    private static final int DEFAULT_CONNECT_TIMEOUT = 500;
    private static final int DEFAULT_READ_TIMEOUT = 10000;

    @Override
    public CheckEnvironmentEnum getCheckEnvironment() {
        return CheckEnvironmentEnum.HTTP;
    }

    @Override
    public boolean isGlobalBlacklist() {
        return true;
    }

    @Override
    public Checked check(CheckPlan plan, Domain domain) {
        String wholeUrl = DomainUtils.getWholeUrl((Domain)domain);
        Checked checked = new Checked();
        checked.setCheckUrl(wholeUrl);
        checked.setCheckResult(this.check0(wholeUrl, plan, checked));
        return checked;
    }

    private CheckResult check0(String url, CheckPlan plan, Checked checked) {
        try {
            RestTemplate restTemplate = this.create(500, 10000);
            ResponseEntity response = restTemplate.getForEntity(url, String.class, new Object[0]);
            int statusCodeValue = response.getStatusCodeValue();
            String body = (String)response.getBody();
            checked.setStatusCode(statusCodeValue);
            checked.setHeaders(JsonHelper.convert((Object)response.getHeaders()));
            checked.setBody(body);
            Integer expectStatusCode = plan.getExpectStatusCode();
            String expectBodyRegex = plan.getExpectBodyRegex();
            boolean expectStatusCodeResult = false;
            boolean expectBodyRegexResult = false;
            if (null != expectStatusCode && statusCodeValue == expectStatusCode) {
                expectStatusCodeResult = true;
            }
            if (StringUtils.isBlank((String)expectBodyRegex)) {
                expectBodyRegexResult = true;
            } else if (StringUtils.isNotBlank((String)expectBodyRegex) && StringUtils.isNotBlank((String)body) && body.matches(expectBodyRegex)) {
                expectBodyRegexResult = true;
            }
            return expectStatusCodeResult && expectBodyRegexResult ? CheckResult.PASSED : CheckResult.NOPASS;
        }
        catch (RestClientException e) {
            if (log.isWarnEnabled()) {
                log.warn("check0: {} - {}", (Object)url, (Object)e.getMessage());
            }
            return CheckResult.NOPASS;
        }
    }

    private RestTemplate create(int connectTimeout, int readTimeout) {
        return new RestTemplateBuilder(new RestTemplateCustomizer[0]).setConnectTimeout(connectTimeout).setReadTimeout(readTimeout).build();
    }
}

