/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.checker.job.worker;

import com.bxm.kylin.checker.checker.Checked;
import com.bxm.kylin.checker.checker.Checker;
import com.bxm.kylin.checker.job.MyJob;
import com.bxm.kylin.core.entity.CheckEnvironment;
import com.bxm.kylin.core.entity.Domain;
import com.bxm.kylin.core.service.ICheckEnvironmentService;
import com.bxm.kylin.core.service.IDomainService;
import java.io.Serializable;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class JobWorkerDispatcher
implements Job {
    private static final Logger log = LoggerFactory.getLogger(JobWorkerDispatcher.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(JobWorkerDispatcher.class);

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDetail jobDetail = jobExecutionContext.getJobDetail();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        Object jobValue = jobDataMap.get((Object)"job");
        if (!(jobValue instanceof MyJob)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Could not found value at jobDataMap [{}]", (Object)"job");
            }
            return;
        }
        MyJob job = (MyJob)((Object)jobValue);
        this.fillEntity(job);
        Checker checker = job.getChecker();
        Domain domain = job.getDomain();
        if (null == checker || null == domain) {
            log.warn("Illegal job: {}", (Object)job);
            return;
        }
        Checked result = checker.check(job, domain);
        jobDataMap.put("result", (Object)result.getCheckResult());
        job.setChecked(result);
    }

    private void fillEntity(MyJob job) {
        ApplicationContext applicationContext = job.getApplicationContext();
        IDomainService domainService = (IDomainService)applicationContext.getBean(IDomainService.class);
        ICheckEnvironmentService checkEnvironmentService = (ICheckEnvironmentService)applicationContext.getBean(ICheckEnvironmentService.class);
        job.setDomain((Domain)domainService.getById((Serializable)job.getDomainId()));
        job.setCheckEnvironment((CheckEnvironment)checkEnvironmentService.getById((Serializable)job.getEnvironmentId()));
    }
}

