/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.checker.listener;

import com.bxm.kylin.checker.job.scheduler.JobScheduler;
import com.bxm.kylin.core.entity.CheckPlan;
import com.bxm.warcar.mq.ConsumeStatus;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.autoconfigure.Subscriber;
import com.bxm.warcar.mq.autoconfigure.SubscriberWrapper;
import com.bxm.warcar.utils.JsonHelper;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Subscriber
public class CheckPlanUpdatingListener
implements SingleMessageListener,
SubscriberWrapper {
    private static final Logger log = LoggerFactory.getLogger(CheckPlanUpdatingListener.class);
    private final JobScheduler jobScheduler;

    public CheckPlanUpdatingListener(JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
    }

    public ConsumeStatus consume(Message message, Object context) {
        String tags = message.getTags();
        byte[] body = message.getBody();
        CheckPlan checkPlan = (CheckPlan)JsonHelper.convert((byte[])body, CheckPlan.class);
        if (StringUtils.equals((String)"delete", (String)tags)) {
            this.jobScheduler.remove(checkPlan);
        }
        if (StringUtils.equals((String)"update", (String)tags)) {
            this.jobScheduler.remove(checkPlan);
            if (checkPlan.getStatus() == 1) {
                this.jobScheduler.trigger(checkPlan);
            }
        }
        if (log.isInfoEnabled()) {
            log.info("[{}] Check plan has been updated.", (Object)checkPlan.getId());
        }
        return ConsumeStatus.CONSUME_SUCCESS;
    }

    public String getTopic() {
        return CheckPlan.class.getName();
    }

    public String getConsumerId() {
        return this.getClass().getName();
    }
}

