/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.checker.trigger;

import com.bxm.kylin.cache.CacheKey;
import com.bxm.kylin.checker.checker.CheckResult;
import com.bxm.kylin.checker.job.MyJob;
import com.bxm.kylin.checker.trigger.AbstractTrigger;
import com.bxm.kylin.core.entity.Domain;
import com.bxm.kylin.utils.DomainUtils;
import com.bxm.warcar.MessageException;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class NotifyTrigger
extends AbstractTrigger {
    private static final Logger log = LoggerFactory.getLogger(NotifyTrigger.class);
    private static final int NOTIFY_MAXIMUM_TIMES = 3;
    private final Counter counter;
    private final Updater updater;
    private final MessageSender messageSender;

    public NotifyTrigger(Counter counter, Updater updater, MessageSender messageSender) {
        this.counter = counter;
        this.updater = updater;
        this.messageSender = messageSender;
    }

    @Override
    protected void handle(MyJob job, CheckResult result) {
    }

    @Override
    protected void doPassed(MyJob job) {
        Long checkPlanId = job.getId();
        if (this.getNotifyTimes(checkPlanId) == 0L) {
            return;
        }
        String message = this.getMessage(job, false);
        this.sendMessage(message);
        this.setRecovered(checkPlanId);
    }

    @Override
    protected void doNoPass(MyJob job) {
        Long checkPlanId = job.getId();
        if (this.getNotifyTimes(checkPlanId) >= 3L) {
            return;
        }
        String message = this.getMessage(job, true);
        this.sendMessage(message);
        this.setWarning(checkPlanId);
    }

    private String getMessage(MyJob job, boolean warning) {
        StringBuilder str = new StringBuilder();
        if (warning) {
            str.append("\u3010\u62a5\u8b66\u3011");
        } else {
            str.append("\u3010\u6062\u590d\u3011");
        }
        Domain domain = job.getDomain();
        str.append(DomainUtils.getWholeUrl((Domain)domain)).append(" ");
        str.append("\u5728 ").append(job.getCheckEnvironment().getEnvironmentName()).append(" \u73af\u5883\u4e0b");
        if (warning) {
            str.append("\u76d1\u6d4b\u4e0d\u901a\u8fc7\uff01");
        } else {
            str.append("\u5df2\u6062\u590d\u3002");
        }
        return str.toString();
    }

    private void sendMessage(String message) {
        try {
            this.messageSender.send2(new Message(message));
        }
        catch (MessageException e) {
            log.warn("sendMessage: {}", (Object)e.getMessage());
        }
    }

    private Long getNotifyTimes(Long checkPlanId) {
        return this.counter.hget(CacheKey.Trigger.warning(), String.valueOf(checkPlanId));
    }

    private void setWarning(Long checkPlanId) {
        this.counter.hincrementAndGet(CacheKey.Trigger.warning(), String.valueOf(checkPlanId));
    }

    private void setRecovered(Long checkPlanId) {
        this.updater.hremove(CacheKey.Trigger.warning(), new String[]{String.valueOf(checkPlanId)});
    }
}

