/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.checker.trigger;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bxm.kylin.checker.checker.CheckResult;
import com.bxm.kylin.checker.checker.Checker;
import com.bxm.kylin.checker.job.MyJob;
import com.bxm.kylin.checker.trigger.AbstractTrigger;
import com.bxm.kylin.core.entity.Blacklist;
import com.bxm.kylin.core.service.IBlacklistService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.dao.DuplicateKeyException;

@Configuration
public class PostBlacklistTrigger
extends AbstractTrigger {
    private static final Logger log = LoggerFactory.getLogger(PostBlacklistTrigger.class);
    private final IBlacklistService blacklistService;

    public PostBlacklistTrigger(IBlacklistService blacklistService) {
        this.blacklistService = blacklistService;
    }

    @Override
    protected void handle(MyJob job, CheckResult result) {
    }

    @Override
    protected void doPassed(MyJob job) {
        Blacklist blacklist = this.getBlacklist(job);
        if (blacklist == null) {
            return;
        }
        this.blacklistService.remove((Wrapper)Wrappers.query((Object)blacklist));
    }

    @Override
    protected void doNoPass(MyJob job) {
        block3: {
            Blacklist blacklist = this.getBlacklist(job);
            if (blacklist == null) {
                return;
            }
            try {
                this.blacklistService.save((Object)blacklist);
            }
            catch (DuplicateKeyException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("blacklist already exist");
            }
        }
    }

    private Blacklist getBlacklist(MyJob job) {
        Checker checker = job.getChecker();
        String feature = checker.getBlacklistFeature();
        if (checker.isGlobalBlacklist()) {
            return null;
        }
        Blacklist blacklist = new Blacklist();
        blacklist.setAuthor(Integer.valueOf(1));
        blacklist.setDomainId(job.getDomainId());
        blacklist.setFeature(feature);
        blacklist.setType(Integer.valueOf(checker.getBlacklistType().value()));
        return blacklist;
    }
}

