/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.redis;

import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.redis.RedisConst;
import com.bxm.warcar.mq.redis.RedisConsumer;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.LifeCycle;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class JedisConsumer
extends LifeCycle
implements Consumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisConsumer.class);
    private final ThreadPoolExecutor consumer = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("JedisConsumer"));
    private final JedisPool jedisPool;
    private final SingleMessageListener messageListener;

    public JedisConsumer(JedisPool jedisPool, SingleMessageListener messageListener) {
        this.jedisPool = jedisPool;
        this.messageListener = messageListener;
    }

    @Override
    protected void doInit() {
        String topic = this.messageListener.getTopic();
        this.consumer.execute(() -> {
            block5: while (true) {
                Jedis jedis = null;
                jedis = this.jedisPool.getResource();
                try {
                    List list = jedis.blpop(1, RedisConst.key(topic));
                    int index = 0;
                    while (true) {
                        String json;
                        Message message;
                        if (index >= list.size()) continue block5;
                        if (index != 0 && null != (message = JsonHelper.convert(json = (String)list.get(index), Message.class))) {
                            this.messageListener.consume(message, jedis);
                        }
                        ++index;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("", (Throwable)e);
                    continue;
                }
                finally {
                    if (null == jedis) continue;
                    jedis.close();
                    continue;
                }
                break;
            }
        });
    }

    @Override
    protected void doDestroy() {
        this.consumer.shutdown();
        try {
            this.consumer.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void suspend() {
    }

    @Override
    public void shutdown() {
        this.doDestroy();
    }

    @Override
    public void start() {
        this.doInit();
    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public Listener getMessageListener() {
        return this.messageListener;
    }
}

