/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.redis;

import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.redis.RedisConst;
import com.bxm.warcar.utils.LifeCycle;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisConsumer
extends LifeCycle
implements Consumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisConsumer.class);
    private final ThreadPoolExecutor consumer = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("RedisConsumer"));
    private final RedisTemplate<String, Message> redisTemplate;
    private final SingleMessageListener messageListener;

    public RedisConsumer(RedisTemplate<String, Message> redisTemplate, SingleMessageListener messageListener) {
        this.redisTemplate = redisTemplate;
        this.messageListener = messageListener;
    }

    @Override
    protected void doInit() {
        String topic = this.messageListener.getTopic();
        this.consumer.execute(() -> {
            while (true) {
                try {
                    while (true) {
                        Message message;
                        if (null == (message = (Message)this.redisTemplate.opsForList().leftPop((Object)RedisConst.key(topic), 1L, TimeUnit.SECONDS))) {
                            continue;
                        }
                        this.messageListener.consume(message, this.redisTemplate);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("", (Throwable)e);
                    continue;
                }
                break;
            }
        });
    }

    @Override
    protected void doDestroy() {
        this.consumer.shutdown();
        try {
            this.consumer.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void suspend() {
    }

    @Override
    public void shutdown() {
        this.doDestroy();
    }

    @Override
    public void start() {
        this.doInit();
    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public Listener getMessageListener() {
        return this.messageListener;
    }
}

