/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.autoconfigure.taskcounter;

import com.bxm.warcar.integration.taskcounter.TaskCountStatistics;
import com.google.common.base.Preconditions;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
public class TaskAspectHandler {
    private final TaskCountStatistics taskMetrics;

    public TaskAspectHandler(TaskCountStatistics taskMetrics) {
        Preconditions.checkNotNull((Object)taskMetrics);
        this.taskMetrics = taskMetrics;
    }

    @Pointcut(value="@annotation(com.bxm.warcar.integration.taskcounter.TaskCounter)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        try {
            this.taskMetrics.increment();
            Object object = point.proceed();
            return object;
        }
        finally {
            this.taskMetrics.decrement();
        }
    }
}

