/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.autoconfigure;

import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.bxm.kylin.CoreProperties;
import com.bxm.kylin.core.interceptor.InjectDomainGroupPropertyInterceptor;
import com.bxm.kylin.core.interceptor.InjectModifyTimeValueInterceptor;
import com.bxm.kylin.core.interceptor.QueueMessengerInterceptor;
import com.bxm.warcar.mq.Producer;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@MapperScan(value={"com.bxm.domain.sentinel.core.mapper"})
@EnableConfigurationProperties(value={CoreProperties.class})
public class MyBatisAutoConfiguration {
    private final CoreProperties coreProperties;

    public MyBatisAutoConfiguration(CoreProperties coreProperties) {
        this.coreProperties = coreProperties;
    }

    @Bean
    public PaginationInterceptor paginationInterceptor() {
        return new PaginationInterceptor();
    }

    @Bean
    public InjectModifyTimeValueInterceptor injectModifyTimeValueInterceptor() {
        return new InjectModifyTimeValueInterceptor();
    }

    @Bean
    public InjectDomainGroupPropertyInterceptor injectDomainGroupPropertyInterceptor() {
        return new InjectDomainGroupPropertyInterceptor();
    }

    @Bean
    public QueueMessengerInterceptor queueMessengerInterceptor(ApplicationContext applicationContext, Producer producer) {
        return new QueueMessengerInterceptor(applicationContext, producer, this.coreProperties.getSendingQueueMessengerIncludeClazz());
    }
}

