/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.core;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import java.io.Serializable;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class BaseController<T> {
    protected abstract IService<T> getService();

    @PutMapping(value={"/put"})
    public ResponseEntity<T> put(@RequestBody T t) {
        if (this.getService().saveOrUpdate(t)) {
            return ResponseEntity.ok(t);
        }
        return ResponseEntity.badRequest().build();
    }

    @DeleteMapping(value={"/delete/{id}"})
    public ResponseEntity<Boolean> delete(@PathVariable(value="id") Long id) {
        if (this.getService().removeById((Serializable)id)) {
            return ResponseEntity.ok((Object)true);
        }
        return ResponseEntity.badRequest().build();
    }

    @GetMapping(value={"/get/{id}"})
    public ResponseEntity<T> get(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.getService().getById((Serializable)id));
    }

    @GetMapping(value={"/list"})
    public ResponseEntity<List<T>> list() {
        return ResponseEntity.ok((Object)this.getService().list());
    }

    @GetMapping(value={"/page"})
    public ResponseEntity<IPage<T>> page(Page<T> page) {
        return ResponseEntity.ok((Object)this.getService().page(page));
    }
}

