/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.core.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class RestTemplateClient {
    private static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36";
    private static final String DEFAULT_REFERER = "https://wx.qq.com/";
    @Autowired
    RestTemplate restTemplate;
    @Resource
    private ObjectMapper objectMapper;

    public String getByHeadParams(String url, LinkedMultiValueMap<String, String> params, Map<String, String> headerParams) {
        HttpHeaders headers = new HttpHeaders();
        if (MapUtils.isNotEmpty(headerParams)) {
            Set<String> set = headerParams.keySet();
            for (String s : set) {
                headers.set(s, headerParams.get(s));
            }
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url).queryParams(params);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(builder.build().encode().toUri(), HttpMethod.GET, entity, String.class);
        return (String)response.getBody();
    }

    public String postByHeadParams(String url, Map<String, Object> params, Map<String, String> headerParams) throws JsonProcessingException {
        HttpHeaders headers = new HttpHeaders();
        if (MapUtils.isNotEmpty(headerParams)) {
            Set<String> set = headerParams.keySet();
            for (String s : set) {
                headers.set(s, headerParams.get(s));
            }
        }
        String body = this.objectMapper.writeValueAsString(params);
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
        return (String)response.getBody();
    }

    public ResponseEntity<String> get(String url, MultiValueMap<String, String> headers) {
        if (null == headers) {
            headers = new LinkedMultiValueMap();
        }
        headers.add((Object)"User-Agent", (Object)DEFAULT_USER_AGENT);
        headers.add((Object)"Referer", (Object)DEFAULT_REFERER);
        HttpMethod method = HttpMethod.GET;
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        LinkedMultiValueMap vars = new LinkedMultiValueMap();
        return this.restTemplate.exchange(url, method, entity, String.class, (Map)vars);
    }
}

