/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.core.interceptor;

import com.bxm.kylin.core.entity.DomainGroup;
import com.bxm.warcar.utils.UUIDHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class InjectDomainGroupPropertyInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(InjectDomainGroupPropertyInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        if (ms.getSqlCommandType() == SqlCommandType.INSERT) {
            Object o = args[1];
            if (o instanceof MapperMethod.ParamMap) {
                MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)args[1];
                for (Object value : paramMap.values()) {
                    this.inject(value);
                }
            } else {
                this.inject(o);
            }
        }
        return invocation.proceed();
    }

    private void inject(Object object) {
        DomainGroup domainGroup;
        if (object instanceof DomainGroup && StringUtils.isBlank((String)(domainGroup = (DomainGroup)object).getSecretKey())) {
            domainGroup.setSecretKey(UUIDHelper.generate());
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }
}

