/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.core.interceptor;

import java.time.LocalDateTime;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class InjectModifyTimeValueInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(InjectModifyTimeValueInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        if (ms.getSqlCommandType() == SqlCommandType.UPDATE) {
            Object o = args[1];
            if (o instanceof MapperMethod.ParamMap) {
                MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)args[1];
                for (Object value : paramMap.values()) {
                    this.setModifyTime(value);
                }
            } else {
                this.setModifyTime(o);
            }
        }
        return invocation.proceed();
    }

    private void setModifyTime(Object o) {
        try {
            MethodUtils.invokeMethod((Object)o, (String)"setModifyTime", (Object)LocalDateTime.now());
        }
        catch (Exception e) {
            log.warn("invokeMethod: ", (Throwable)e);
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }
}

