/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.core.interceptor;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.kylin.core.BaseEntity;
import com.bxm.kylin.core.ServiceException;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.SendException;
import com.bxm.warcar.utils.JsonHelper;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class QueueMessengerInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(QueueMessengerInterceptor.class);
    private final ApplicationContext applicationContext;
    private final Producer producer;
    private final Set<Class<?>> includes;

    public QueueMessengerInterceptor(ApplicationContext applicationContext, Producer producer, Set<Class<?>> includes) {
        this.applicationContext = applicationContext;
        this.producer = producer;
        this.includes = includes;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object o = args[1];
        boolean isUpdate = false;
        Object proceed = null;
        switch (ms.getSqlCommandType()) {
            case INSERT: 
            case UPDATE: {
                isUpdate = true;
                proceed = invocation.proceed();
                break;
            }
        }
        if (o instanceof MapperMethod.ParamMap) {
            MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)args[1];
            for (Map.Entry entry : paramMap.entrySet()) {
                String key = (String)entry.getKey();
                if (!StringUtils.equals((String)key, (String)"et")) continue;
                this.sendMessage(ms, entry.getValue());
            }
        } else {
            this.sendMessage(ms, o);
        }
        return isUpdate ? proceed : invocation.proceed();
    }

    private void sendMessage(MappedStatement ms, Object object) {
        try {
            Class<?> actualTypeName;
            Class<?> mapperClazz = Class.forName(StringUtils.substring((String)ms.getId(), (int)0, (int)ms.getId().lastIndexOf(".")));
            Object bean = this.applicationContext.getBean(mapperClazz);
            Type[] genericInterfaces = mapperClazz.getGenericInterfaces();
            if (genericInterfaces.length > 1) {
                log.error("{} Unsupported multiple generic interfaces!", mapperClazz);
                return;
            }
            Type[] arguments = ((ParameterizedType)genericInterfaces[0]).getActualTypeArguments();
            if (arguments.length > 1) {
                log.error("{} Unsupported multiple actual type arguments!", mapperClazz);
            }
            if (!this.isInclude(actualTypeName = Class.forName(arguments[0].getTypeName()))) {
                return;
            }
            switch (ms.getSqlCommandType()) {
                case INSERT: 
                case UPDATE: {
                    if (!(object instanceof BaseEntity)) break;
                    Serializable id = ((BaseEntity)object).getId();
                    Object o = ((BaseMapper)bean).selectById(id);
                    log.info("Updated: {}", o);
                    this.send(o, ms.getSqlCommandType());
                    break;
                }
                case DELETE: {
                    if (!(object instanceof Serializable)) break;
                    Object o = ((BaseMapper)bean).selectById((Serializable)object);
                    if (null == o) {
                        log.info("{}#{} Does not exists!", actualTypeName, object);
                        break;
                    }
                    log.info("Deleting: {}", o);
                    this.send(o, ms.getSqlCommandType());
                    break;
                }
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("sendMessage: ", (Throwable)e);
        }
    }

    private void send(Object object, SqlCommandType sqlCommandType) {
        try {
            String tag;
            String string = sqlCommandType == SqlCommandType.INSERT || sqlCommandType == SqlCommandType.UPDATE ? "update" : (tag = sqlCommandType == SqlCommandType.DELETE ? "delete" : null);
            if (StringUtils.isBlank((String)tag)) {
                log.warn("Unsupported SqlCommandType: {}", (Object)sqlCommandType);
                return;
            }
            String topic = ClassUtils.getUserClass(object.getClass()).getName();
            Message message = new Message(topic, tag, 0, JsonHelper.convert2bytes((Object)object));
            this.producer.send(message);
        }
        catch (SendException e) {
            throw new ServiceException("send: ", e);
        }
    }

    private boolean isInclude(Class<?> clazz) {
        for (Class<?> include : this.includes) {
            if (!clazz.isAssignableFrom(include)) continue;
            return true;
        }
        return false;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }
}

