/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.core.listener;

import com.bxm.kylin.core.WeChatTicket;
import com.bxm.kylin.core.event.LoginSuccessEvent;
import com.bxm.kylin.core.service.WeChatService;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LoginSuccessListener
implements EventListener<LoginSuccessEvent> {
    private static final Logger log = LoggerFactory.getLogger(LoginSuccessListener.class);
    private final WeChatService weChatService;

    public LoginSuccessListener(WeChatService weChatService) {
        this.weChatService = weChatService;
    }

    @Subscribe
    public void consume(LoginSuccessEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("LoginSuccessEvent in");
        }
        List<String> cookies = event.getCookies();
        WeChatTicket ticket = this.weChatService.getTicket();
        ticket.setCookies(cookies);
        this.weChatService.updateTicket(ticket);
    }
}

