/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.core.listener;

import com.bxm.kylin.core.event.LoginSuccessEvent;
import com.bxm.kylin.core.event.QrcodeScannedEvent;
import com.bxm.kylin.utils.RestUtils;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

@Configuration
public class QrcodeScannedListener
implements EventListener<QrcodeScannedEvent> {
    private static final Logger log = LoggerFactory.getLogger(QrcodeScannedListener.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(QrcodeScannedListener.class);
    private final RestTemplate restTemplate;
    private final EventPark eventPark;

    public QrcodeScannedListener(RestTemplate restTemplate, EventPark eventPark) {
        this.restTemplate = restTemplate;
        this.eventPark = eventPark;
    }

    @Subscribe
    public void consume(QrcodeScannedEvent event) {
        ResponseEntity<String> response;
        HttpHeaders responseHeaders;
        List cookies;
        if (log.isDebugEnabled()) {
            log.debug("QrcodeScannedEvent in");
        }
        String redirectUri = event.getRedirectUri();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(redirectUri);
        }
        if (CollectionUtils.isEmpty((Collection)(cookies = (responseHeaders = (response = RestUtils.get(this.restTemplate, redirectUri + "&fun=new&version=v2&lang=zh_CN")).getHeaders()).get((Object)"Set-Cookie")))) {
            LOGGER.warn("\u6ca1\u6709\u8fd4\u56de\u4efb\u4f55 Cookie \u4fe1\u606f\u3002{}", (Object)redirectUri);
            return;
        }
        String ticketSrc = (String)response.getBody();
        if (StringUtils.isBlank((String)ticketSrc)) {
            LOGGER.warn("\u6ca1\u6709\u8fd4\u56de\u4efb\u4f55\u63a5\u53e3\u7968\u636e\u4fe1\u606f\u3002{}", (Object)redirectUri);
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Ticket: {}", (Object)ticketSrc);
        }
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read((Reader)new StringReader(ticketSrc));
            Element root = document.getRootElement();
            String skey = root.selectSingleNode("/error/skey").getText();
            String wxsid = root.selectSingleNode("/error/wxsid").getText();
            String wxuin = root.selectSingleNode("/error/wxuin").getText();
            String passTicket = root.selectSingleNode("/error/pass_ticket").getText();
            this.eventPark.post((EventObject)new LoginSuccessEvent(this, cookies, skey, wxsid, wxuin, passTicket));
            if (log.isDebugEnabled()) {
                log.debug("post LoginSuccessEvent");
            }
        }
        catch (DocumentException e) {
            LOGGER.error("\u8fd4\u56de\u7684\u4fe1\u606f\u65e0\u6cd5\u89e3\u6790\u3002" + ticketSrc, (Throwable)e);
        }
    }
}

