/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.core.listener;

import com.bxm.kylin.core.WeChatTicket;
import com.bxm.kylin.core.event.QrcodeScannedEvent;
import com.bxm.kylin.core.event.UuidReceivedEvent;
import com.bxm.kylin.core.service.WeChatService;
import com.bxm.kylin.core.service.impl.WeChatServiceImpl;
import com.bxm.kylin.utils.RestUtils;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.EventObject;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

@Configuration
public class UuidReceivedListener
implements EventListener<UuidReceivedEvent> {
    private static final Logger log = LoggerFactory.getLogger(UuidReceivedListener.class);
    private final ThreadPoolExecutor pool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("login-monitor"));
    private final WeChatService weChatService;
    private final EventPark eventPark;
    private final RestTemplate restTemplate;

    public UuidReceivedListener(WeChatService weChatService, EventPark eventPark, RestTemplate restTemplate) {
        this.weChatService = weChatService;
        this.eventPark = eventPark;
        this.restTemplate = restTemplate;
    }

    @Subscribe
    public void consume(UuidReceivedEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("UuidReceivedEvent in");
        }
        WeChatTicket ticket = this.weChatService.getTicket();
        this.pool.execute(() -> {
            Object redirect;
            while (true) {
                String url;
                ResponseEntity<String> responseEntity;
                String body;
                if (StringUtils.isBlank((String)(body = (String)(responseEntity = RestUtils.get(this.restTemplate, url = "https://login.wx.qq.com/cgi-bin/mmwebwx-bin/login?loginicon=true&uuid=" + ticket.getUuid() + "&tip=0" + "&r=" + RandomUtils.nextDouble() + "&_=" + String.valueOf(System.currentTimeMillis()), null)).getBody()))) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("body isBlank");
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("body {}", (Object)body);
                }
                Properties properties = WeChatServiceImpl.of1(body);
                redirect = properties.get("window.redirect_uri");
                Object userAvatar = properties.get("window.userAvatar");
                if (userAvatar != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("setUserAvatar {}", userAvatar);
                    }
                    String avatar = String.valueOf(userAvatar);
                    int pos = avatar.lastIndexOf(";");
                    ticket.setUserAvatar(avatar.substring(0, pos));
                    this.weChatService.updateTicket(ticket);
                }
                if (null != redirect) break;
            }
            String redirectUri = redirect.toString();
            this.eventPark.post((EventObject)new QrcodeScannedEvent(this, ticket.getUuid(), redirectUri));
            if (log.isDebugEnabled()) {
                log.debug("post QrcodeScannedEvent redirectUri={}", (Object)redirectUri);
            }
        });
    }
}

