/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.kylin.core.service.impl;

import com.bxm.kylin.core.service.QqService;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.utils.TypeHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class QqServiceImpl
implements QqService {
    private static final Logger log = LoggerFactory.getLogger(QqServiceImpl.class);
    private final AtomicBoolean isLogin = new AtomicBoolean(false);
    private final HttpClient httpClient = HttpClientBuilder.create().build();
    private final ExecutorService executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("login-check"));
    private final ConcurrentHashMap<String, String> requestCookie = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> sessionCookie = new ConcurrentHashMap();

    private void initXlogin() {
        HttpGet get = new HttpGet("https://xui.ptlogin2.qq.com/cgi-bin/xlogin?appid=501038301&target=self&s_url=https://im.qq.com/loginSuccess.html");
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            this.putCookie(this.requestCookie, response.getHeaders("Set-Cookie"));
        }
        catch (IOException e) {
            log.error("initXlogin: ", (Throwable)e);
        }
    }

    @Override
    public byte[] getQrcode() {
        this.initXlogin();
        HttpGet get = new HttpGet("https://ssl.ptlogin2.qq.com/ptqrshow?appid=501038301&e=2&l=M&s=3&d=72&v=4&t=" + RandomUtils.nextDouble() + "&pt_3rd_aid=0");
        this.setCookie((HttpRequestBase)get);
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            this.putCookie(this.requestCookie, response.getHeaders("Set-Cookie"));
            this.executeLoopCheck();
            HttpEntity entity = response.getEntity();
            return IOUtils.readFully((InputStream)entity.getContent(), (int)TypeHelper.castToInt((Object)entity.getContentLength()));
        }
        catch (IOException e) {
            log.error("getQrcode: ", (Throwable)e);
            return new byte[0];
        }
    }

    @Override
    public Map<String, String> getSessionCookie() {
        return this.sessionCookie;
    }

    @Override
    public boolean isLogin() {
        return this.isLogin.get();
    }

    private void executeLoopCheck() {
        this.executor.execute(() -> {
            while (true) {
                HttpGet get = new HttpGet("https://ssl.ptlogin2.qq.com/ptqrlogin?u1=https%3A%2F%2Fim.qq.com%2FloginSuccess.html&ptqrtoken=" + QqServiceImpl.hash33(this.requestCookie.get("qrsig")) + "&ptredirect=0" + "&h=1" + "&t=1" + "&g=1" + "&from_ui=1" + "&ptlang=2052" + "&action=0-0-" + System.currentTimeMillis() + "&js_ver=19091015" + "&js_type=1" + "&login_sig=" + this.requestCookie.get("pt_login_sig") + "&pt_uistyle=40" + "&aid=501038301&");
                this.setCookie((HttpRequestBase)get);
                try {
                    HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
                    HttpEntity entity = response.getEntity();
                    InputStream inputStream = entity.getContent();
                    List lines = IOUtils.readLines((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    String body = StringUtils.join((Collection)lines, (String)"\n");
                    if (!StringUtils.contains((String)body, (String)"\u767b\u5f55\u6210\u529f")) {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    this.putCookie(this.sessionCookie, response.getHeaders("Set-Cookie"));
                    this.isLogin.set(true);
                    return;
                }
                catch (IOException e) {
                    log.error("execute: ", (Throwable)e);
                    continue;
                }
                break;
            }
        });
    }

    private void setCookie(HttpRequestBase base) {
        StringBuilder cookie = new StringBuilder();
        for (Map.Entry<String, String> entry : this.requestCookie.entrySet()) {
            cookie.append(entry.getKey()).append("=").append(entry.getValue()).append(";");
        }
        base.setHeader((Header)new BasicHeader("Cookie", cookie.toString()));
    }

    private void putCookie(ConcurrentHashMap<String, String> map, Header[] cookie) {
        for (Header header : cookie) {
            String value = header.getValue();
            String v = value.split(";")[0];
            String[] split = v.split("=");
            if (split.length < 2) continue;
            map.put(split[0], split[1]);
        }
    }

    private static long hash33(String t) {
        int e = 0;
        for (int i = 0; i < t.length(); ++i) {
            e += (e << 5) + t.charAt(i);
        }
        return Integer.MAX_VALUE & e;
    }
}

